/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.Sigar;

public class RPC {
    private static Map programs = null;
    public static final int UDP = 32;
    public static final int TCP = 16;

    public static native int ping(String var0, int var1, long var2, long var4);

    public static native String strerror(int var0);

    public static int ping(String hostname, int protocol, String program, long version) {
        return RPC.ping(hostname, protocol, RPC.getProgram(program), version);
    }

    public static int ping(String hostname, long program) {
        return RPC.ping(hostname, 32, program, 2L);
    }

    public static int ping(String hostname, String program) {
        return RPC.ping(hostname, 32, program, 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parse(String fileName) {
        String line;
        programs = new HashMap();
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || (st = new StringTokenizer(line, " \t")).countTokens() < 2) continue;
            String name = st.nextToken().trim();
            String num = st.nextToken().trim();
            programs.put(name, num);
        }
        Object var8_8 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                Object var8_9 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static long getProgram(String program) {
        Long num;
        Object obj;
        if (programs == null) {
            RPC.parse("/etc/rpc");
        }
        if ((obj = programs.get(program)) == null) {
            return -1L;
        }
        if (obj instanceof Long) {
            num = (Long)obj;
        } else {
            num = Long.valueOf((String)obj);
            programs.put(program, num);
        }
        return num;
    }

    public static void main(String[] args) throws Exception {
        Sigar.load();
        int retval = RPC.ping(args[0], args[1]);
        System.out.println("(" + retval + ") " + RPC.strerror(retval));
    }
}

