/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.io.File;
import java.io.IOException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.cmd.CpuInfo;
import org.hyperic.sigar.cmd.Df;
import org.hyperic.sigar.cmd.Du;
import org.hyperic.sigar.cmd.Free;
import org.hyperic.sigar.cmd.Ifconfig;
import org.hyperic.sigar.cmd.Iostat;
import org.hyperic.sigar.cmd.Kill;
import org.hyperic.sigar.cmd.MultiPs;
import org.hyperic.sigar.cmd.NetInfo;
import org.hyperic.sigar.cmd.Netstat;
import org.hyperic.sigar.cmd.Nfsstat;
import org.hyperic.sigar.cmd.ProcFileInfo;
import org.hyperic.sigar.cmd.ProcInfo;
import org.hyperic.sigar.cmd.ProcModuleInfo;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Route;
import org.hyperic.sigar.cmd.ShowArgs;
import org.hyperic.sigar.cmd.ShowEnv;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.SysInfo;
import org.hyperic.sigar.cmd.Time;
import org.hyperic.sigar.cmd.Ulimit;
import org.hyperic.sigar.cmd.Uptime;
import org.hyperic.sigar.cmd.Version;
import org.hyperic.sigar.cmd.Who;
import org.hyperic.sigar.cmd.Win32Service;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.test.SigarTestCase;
import org.hyperic.sigar.test.SigarTestRunner;
import org.hyperic.sigar.util.Getline;

public class Shell
extends ShellBase {
    public static final String RCFILE_NAME = ".sigar_shellrc";
    private static final String CLEAR_SCREEN = "\u001b[2J";
    private Sigar sigar = new Sigar();
    private SigarProxy proxy = SigarProxyCache.newInstance(this.sigar);
    private long[] foundPids = new long[0];
    private boolean isInteractive = false;

    public static void clearScreen() {
        System.out.print(CLEAR_SCREEN);
    }

    public SigarProxy getSigarProxy() {
        return this.proxy;
    }

    public Sigar getSigar() {
        return this.sigar;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean value) {
        this.isInteractive = value;
    }

    public void registerCommands() throws ShellCommandInitException {
        this.registerCommandHandler("df", new Df(this));
        this.registerCommandHandler("du", new Du(this));
        this.registerCommandHandler("iostat", new Iostat(this));
        this.registerCommandHandler("free", new Free(this));
        this.registerCommandHandler("pargs", new ShowArgs(this));
        this.registerCommandHandler("penv", new ShowEnv(this));
        this.registerCommandHandler("pfile", new ProcFileInfo(this));
        this.registerCommandHandler("pmodules", new ProcModuleInfo(this));
        this.registerCommandHandler("pinfo", new ProcInfo(this));
        this.registerCommandHandler("cpuinfo", new CpuInfo(this));
        this.registerCommandHandler("ifconfig", new Ifconfig(this));
        this.registerCommandHandler("uptime", new Uptime(this));
        this.registerCommandHandler("ps", new Ps(this));
        this.registerCommandHandler("kill", new Kill(this));
        this.registerCommandHandler("netstat", new Netstat(this));
        this.registerCommandHandler("netinfo", new NetInfo(this));
        this.registerCommandHandler("nfsstat", new Nfsstat(this));
        this.registerCommandHandler("route", new Route(this));
        this.registerCommandHandler("version", new Version(this));
        this.registerCommandHandler("mps", new MultiPs(this));
        this.registerCommandHandler("sysinfo", new SysInfo(this));
        this.registerCommandHandler("time", new Time(this));
        this.registerCommandHandler("ulimit", new Ulimit(this));
        this.registerCommandHandler("who", new Who(this));
        if (SigarLoader.IS_WIN32) {
            this.registerCommandHandler("service", new Win32Service(this));
        }
        try {
            this.registerCommandHandler("test", new SigarTestRunner(this));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommand(ShellCommandHandler handler, String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        try {
            super.processCommand(handler, args);
            if (handler instanceof SigarCommandBase) {
                ((SigarCommandBase)handler).flush();
            }
        }
        finally {
            SigarProxyCache.clear(this.proxy);
        }
    }

    public static long[] getPids(SigarProxy sigar, String[] args) throws SigarException {
        long[] pids;
        switch (args.length) {
            case 0: {
                pids = new long[]{sigar.getPid()};
                break;
            }
            case 1: {
                if (args[0].indexOf("=") > 0) {
                    pids = ProcessFinder.find(sigar, args[0]);
                    break;
                }
                if (args[0].equals("$$")) {
                    pids = new long[]{sigar.getPid()};
                    break;
                }
                pids = new long[]{Long.parseLong(args[0])};
                break;
            }
            default: {
                pids = new long[args.length];
                for (int i = 0; i < args.length; ++i) {
                    pids[i] = Long.parseLong(args[i]);
                }
            }
        }
        return pids;
    }

    public long[] findPids(String[] args) throws SigarException {
        if (args.length == 1 && args[0].equals("-")) {
            return this.foundPids;
        }
        this.foundPids = Shell.getPids(this.proxy, args);
        return this.foundPids;
    }

    public void readCommandFile(String dir) {
        try {
            File rc = new File(dir, RCFILE_NAME);
            this.readRCFile(rc, false);
            if (this.isInteractive && Getline.isTTY()) {
                this.out.println("Loaded rc file: " + rc);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getUserDeniedMessage(long pid) {
        return SigarPermissionDeniedException.getUserDeniedMessage(this.proxy, pid);
    }

    public void shutdown() {
        this.sigar.close();
        SigarTestCase.closeSigar();
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Shell shell = new Shell();
        try {
            if (args.length == 0) {
                shell.isInteractive = true;
            }
            shell.init("sigar", System.out, System.err);
            shell.registerCommands();
            shell.readCommandFile(System.getProperty("user.home"));
            shell.readCommandFile(".");
            shell.readCommandFile(SigarLoader.getLocation());
            if (shell.isInteractive) {
                shell.initHistory();
                Getline.setCompleter(shell);
                shell.run();
            } else {
                shell.handleCommand(null, args);
            }
        }
        catch (Exception e) {
            System.err.println("Unexpected exception: " + e);
        }
        finally {
            shell.shutdown();
        }
    }
}

