/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.jmx.AbstractMBean;

public class SigarCpu
extends AbstractMBean {
    private static final String MBEAN_TYPE = "CpuList";
    private static final MBeanInfo MBEAN_INFO;
    private static final MBeanAttributeInfo MBEAN_ATTR_CPUINDEX;
    private static final MBeanAttributeInfo MBEAN_ATTR_IDLE;
    private static final MBeanAttributeInfo MBEAN_ATTR_NICE;
    private static final MBeanAttributeInfo MBEAN_ATTR_SYS;
    private static final MBeanAttributeInfo MBEAN_ATTR_TOTAL;
    private static final MBeanAttributeInfo MBEAN_ATTR_USER;
    private static final MBeanAttributeInfo MBEAN_ATTR_WAIT;
    private static final MBeanConstructorInfo MBEAN_CONSTR_CPUINDEX;
    private static final MBeanConstructorInfo MBEAN_CONSTR_CPUINDEX_SIGAR;
    private static MBeanParameterInfo MBEAN_PARAM_CPUINDEX;
    private static MBeanParameterInfo MBEAN_PARAM_SIGAR;
    private final int cpuIndex;
    private final String objectName;
    static /* synthetic */ Class class$org$hyperic$sigar$Sigar;
    static /* synthetic */ Class class$org$hyperic$sigar$jmx$SigarCpu;

    public SigarCpu(int cpuIndex) throws IllegalArgumentException {
        this(new Sigar(), cpuIndex);
    }

    public SigarCpu(Sigar sigar, int cpuIndex) throws IllegalArgumentException {
        super(sigar, (short)2);
        if (cpuIndex < 0) {
            throw new IllegalArgumentException("CPU index has to be non-negative: " + cpuIndex);
        }
        try {
            int cpuCount = sigar.getCpuList().length;
            if (cpuCount < cpuIndex) {
                throw new IllegalArgumentException("CPU index out of range (found " + cpuCount + " CPU(s)): " + cpuIndex);
            }
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
        this.cpuIndex = cpuIndex;
        this.objectName = "sigar:type=Cpu," + MBEAN_ATTR_CPUINDEX.getName().substring(0, 1).toLowerCase() + MBEAN_ATTR_CPUINDEX.getName().substring(1) + "=" + cpuIndex;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getCpuIndex() {
        return this.cpuIndex;
    }

    public long getIdle() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getIdle();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public long getNice() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getNice();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public long getSys() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getSys();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public long getTotal() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getTotal();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public long getUser() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getUser();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public long getWait() {
        try {
            return this.sigar.getCpuList()[this.cpuIndex].getWait();
        }
        catch (SigarException e) {
            throw this.unexpectedError(MBEAN_TYPE, e);
        }
    }

    public Object getAttribute(String attr) throws AttributeNotFoundException {
        if (MBEAN_ATTR_CPUINDEX.getName().equals(attr)) {
            return new Integer(this.getCpuIndex());
        }
        if (MBEAN_ATTR_IDLE.getName().equals(attr)) {
            return new Long(this.getIdle());
        }
        if (MBEAN_ATTR_NICE.getName().equals(attr)) {
            return new Long(this.getNice());
        }
        if (MBEAN_ATTR_SYS.getName().equals(attr)) {
            return new Long(this.getSys());
        }
        if (MBEAN_ATTR_TOTAL.getName().equals(attr)) {
            return new Long(this.getTotal());
        }
        if (MBEAN_ATTR_USER.getName().equals(attr)) {
            return new Long(this.getUser());
        }
        if (MBEAN_ATTR_WAIT.getName().equals(attr)) {
            return new Long(this.getWait());
        }
        throw new AttributeNotFoundException(attr);
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attr.getName());
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException {
        throw new ReflectionException(new NoSuchMethodException(actionName), actionName);
    }

    public MBeanInfo getMBeanInfo() {
        return MBEAN_INFO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MBEAN_ATTR_CPUINDEX = new MBeanAttributeInfo("CpuIndex", "int", "The index of the CPU, typically starting at 0", true, false, false);
        MBEAN_ATTR_IDLE = new MBeanAttributeInfo("Idle", "long", "The idle time of the CPU, in [ms]", true, false, false);
        MBEAN_ATTR_NICE = new MBeanAttributeInfo("Nice", "long", "The time of the CPU spent on nice priority, in [ms]", true, false, false);
        MBEAN_ATTR_SYS = new MBeanAttributeInfo("Sys", "long", "The time of the CPU used by the system, in [ms]", true, false, false);
        MBEAN_ATTR_TOTAL = new MBeanAttributeInfo("Total", "long", "The total time of the CPU, in [ms]", true, false, false);
        MBEAN_ATTR_USER = new MBeanAttributeInfo("User", "long", "The time of the CPU used by user processes, in [ms]", true, false, false);
        MBEAN_ATTR_WAIT = new MBeanAttributeInfo("Wait", "long", "The time the CPU had to wait for data to be loaded, in [ms]", true, false, false);
        MBEAN_PARAM_CPUINDEX = new MBeanParameterInfo("cpuIndex", "int", "The index of the CPU to read data for. Must be >= 0 and not exceed the CPU count of the system");
        MBEAN_PARAM_SIGAR = new MBeanParameterInfo("sigar", (class$org$hyperic$sigar$Sigar == null ? (class$org$hyperic$sigar$Sigar = SigarCpu.class$("org.hyperic.sigar.Sigar")) : class$org$hyperic$sigar$Sigar).getName(), "The Sigar instance to use to fetch data from");
        MBEAN_CONSTR_CPUINDEX = new MBeanConstructorInfo((class$org$hyperic$sigar$jmx$SigarCpu == null ? (class$org$hyperic$sigar$jmx$SigarCpu = SigarCpu.class$("org.hyperic.sigar.jmx.SigarCpu")) : class$org$hyperic$sigar$jmx$SigarCpu).getName(), "Creates a new instance for the CPU index specified, using a new Sigar instance to fetch the data. Fails if the CPU index is out of range.", new MBeanParameterInfo[]{MBEAN_PARAM_CPUINDEX});
        MBEAN_CONSTR_CPUINDEX_SIGAR = new MBeanConstructorInfo((class$org$hyperic$sigar$jmx$SigarCpu == null ? (class$org$hyperic$sigar$jmx$SigarCpu = SigarCpu.class$("org.hyperic.sigar.jmx.SigarCpu")) : class$org$hyperic$sigar$jmx$SigarCpu).getName(), "Creates a new instance for the CPU index specified, using the Sigar instance specified to fetch the data. Fails if the CPU index is out of range.", new MBeanParameterInfo[]{MBEAN_PARAM_SIGAR, MBEAN_PARAM_CPUINDEX});
        MBEAN_INFO = new MBeanInfo((class$org$hyperic$sigar$jmx$SigarCpu == null ? (class$org$hyperic$sigar$jmx$SigarCpu = SigarCpu.class$("org.hyperic.sigar.jmx.SigarCpu")) : class$org$hyperic$sigar$jmx$SigarCpu).getName(), "Sigar CPU MBean. Provides raw timing data for a single CPU. The data is cached for 500ms, meaning each request (and as a result each block request to all parameters) within half a second is satisfied from the same dataset.", new MBeanAttributeInfo[]{MBEAN_ATTR_CPUINDEX, MBEAN_ATTR_IDLE, MBEAN_ATTR_NICE, MBEAN_ATTR_SYS, MBEAN_ATTR_TOTAL, MBEAN_ATTR_USER, MBEAN_ATTR_WAIT}, new MBeanConstructorInfo[]{MBEAN_CONSTR_CPUINDEX, MBEAN_CONSTR_CPUINDEX_SIGAR}, null, null);
    }
}

