/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.hyperic.sigar.Sigar;

public abstract class SigarTestCase
extends TestCase {
    private static Sigar sigar = null;
    private Properties props = new Properties();
    private static boolean verbose = "true".equals(System.getProperty("sigar.testVerbose"));
    protected static final boolean JDK_14_COMPAT = System.getProperty("java.specification.version").compareTo("1.4") >= 0;
    private static PrintStream out = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SigarTestCase(String name) {
        super(name);
        File f = new File(System.getProperty("user.home"), ".sigar.properties");
        if (!f.exists()) return;
        FileInputStream is = null;
        is = new FileInputStream(f);
        this.props.load(is);
        Object var6_4 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var6_5 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Sigar getSigar() {
        if (sigar == null) {
            sigar = new Sigar();
            if (SigarTestCase.getVerbose()) {
                sigar.enableLogging(true);
            }
        }
        return sigar;
    }

    public static void closeSigar() {
        if (sigar != null) {
            sigar.close();
            sigar = null;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key, String val) {
        return this.getProperties().getProperty(key, val);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public static void setVerbose(boolean value) {
        verbose = value;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setWriter(PrintStream value) {
        out = value;
    }

    public static PrintStream getWriter() {
        return out;
    }

    public long getInvalidPid() {
        return 666666L;
    }

    public void traceln(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().println(msg);
        }
    }

    public void trace(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().print(msg);
        }
    }

    public void assertTrueTrace(String msg, String value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue((String)msg, (value != null ? 1 : 0) != 0);
    }

    public void assertLengthTrace(String msg, String value) {
        this.assertTrueTrace(msg, value);
        SigarTestCase.assertTrue((String)msg, (value.length() > 0 ? 1 : 0) != 0);
    }

    public void assertIndexOfTrace(String msg, String value, String substr) {
        this.assertTrueTrace(msg, value);
        SigarTestCase.assertTrue((String)msg, (value.indexOf(substr) != -1 ? 1 : 0) != 0);
    }

    public void assertGtZeroTrace(String msg, long value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue((String)msg, (value > 0L ? 1 : 0) != 0);
    }

    public void assertGtEqZeroTrace(String msg, long value) {
        this.traceln(msg + "=" + value);
        SigarTestCase.assertTrue((String)msg, (value >= 0L ? 1 : 0) != 0);
    }

    public void assertEqualsTrace(String msg, long expected, long actual) {
        this.traceln(msg + "=" + actual + "/" + expected);
        SigarTestCase.assertEquals((String)msg, (long)expected, (long)actual);
    }

    public void traceMethods(Object obj) throws Exception {
        Class<?> cls = obj.getClass();
        Method[] methods = cls.getDeclaredMethods();
        this.traceln("");
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            Object val = methods[i].invoke(obj, new Object[0]);
            if (val instanceof Long && (Long)val == -1L) {
                val = "NOTIMPL";
            }
            this.traceln(name + "=" + val);
        }
    }
}

