/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestCpu
extends SigarTestCase {
    public TestCpu(String name) {
        super(name);
    }

    private void checkCpu(Cpu cpu) {
        this.traceln("User..." + cpu.getUser());
        TestCpu.assertTrue((cpu.getUser() >= 0L ? 1 : 0) != 0);
        this.traceln("Sys...." + cpu.getSys());
        TestCpu.assertTrue((cpu.getSys() >= 0L ? 1 : 0) != 0);
        this.traceln("Idle..." + cpu.getIdle());
        TestCpu.assertTrue((cpu.getIdle() >= 0L ? 1 : 0) != 0);
        this.traceln("Wait..." + cpu.getWait());
        TestCpu.assertTrue((cpu.getWait() >= 0L ? 1 : 0) != 0);
        this.traceln("Total.." + cpu.getTotal());
        TestCpu.assertTrue((cpu.getTotal() > 0L ? 1 : 0) != 0);
        try {
            long current = this.getSigar().getProcState("$$").getProcessor();
            this.traceln("last run cpu=" + current);
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        Cpu cpu = sigar.getCpu();
        this.traceln("getCpu:");
        this.checkCpu(cpu);
        try {
            Cpu[] cpuList = sigar.getCpuList();
            for (int i = 0; i < cpuList.length; ++i) {
                this.traceln("Cpu " + i + ":");
                this.checkCpu(cpuList[i]);
            }
        }
        catch (SigarNotImplementedException sigarNotImplementedException) {
            // empty catch block
        }
    }

    private static void printCpu(String prefix, CpuPerc cpu) {
        System.out.println(prefix + CpuPerc.format(cpu.getUser()) + "\t" + CpuPerc.format(cpu.getSys()) + "\t" + CpuPerc.format(cpu.getWait()) + "\t" + CpuPerc.format(cpu.getNice()) + "\t" + CpuPerc.format(cpu.getIdle()) + "\t" + CpuPerc.format(cpu.getCombined()));
    }

    public static void main(String[] args) throws Exception {
        String HEADER = "   User\tSys\tWait\tNice\tIdle\tTotal";
        int interval = 1;
        if (args.length > 0) {
            interval = Integer.parseInt(args[0]);
        }
        int sleep = 60000 * interval;
        Sigar sigar = new Sigar();
        while (true) {
            System.out.println("   User\tSys\tWait\tNice\tIdle\tTotal");
            TestCpu.printCpu("   ", sigar.getCpuPerc());
            CpuPerc[] cpuList = sigar.getCpuPercList();
            for (int i = 0; i < cpuList.length; ++i) {
                TestCpu.printCpu(i + ": ", cpuList[i]);
            }
            Thread.sleep(sleep);
        }
    }
}

