/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.jmx.SigarInvokerJMX;
import org.hyperic.sigar.test.SigarTestCase;

public class TestInvoker
extends SigarTestCase {
    private static final String[][] OK_QUERIES = new String[][]{{"sigar:Type=Mem", "Free"}, {"sigar:Type=Mem", "Total"}, {"sigar:Type=Cpu", "User"}, {"sigar:Type=Cpu", "Sys"}, {"sigar:Type=CpuPerc", "User"}, {"sigar:Type=CpuPerc", "Sys"}, {"sigar:Type=Swap", "Free"}, {"sigar:Type=Swap", "Used"}, {"sigar:Type=Uptime", "Uptime"}, {"sigar:Type=LoadAverage", "0"}, {"sigar:Type=LoadAverage", "1"}, {"sigar:Type=LoadAverage", "2"}, {"sigar:Type=ProcMem,Arg=$$", "Size"}, {"sigar:Type=ProcMem,Arg=$$", "Resident"}, {"sigar:Type=ProcTime,Arg=$$", "Sys"}, {"sigar:Type=ProcTime,Arg=$$", "User"}, {"sigar:Type=ProcTime,Arg=$$", "Total"}, {"sigar:Type=MultiProcCpu,Arg=CredName.User.eq%3Ddougm", "Sys"}, {"sigar:Type=MultiProcMem,Arg=CredName.User.eq%3Ddougm", "Size"}, {"sigar:Type=ProcTime,Arg=$$", "Stime"}, {"sigar:Type=ProcTime,Arg=$$", "Utime"}, {"sigar:Type=CpuPercList,Arg=0", "Idle"}, {"sigar:Type=NetStat", "TcpOutboundTotal"}, {"sigar:Type=NetStat", "TcpListen"}};
    private static final String[][] BROKEN_QUERIES = new String[][]{{"sigar:Type=BREAK", "Free"}, {"sigar:Type=Mem", "BREAK"}, {"sigar:Type=ProcTime,Arg=BREAK", "Sys"}, {"sigar:Type=CpuPercList,Arg=1000", "Idle"}, {"sigar:Type=CpuPercList,Arg=BREAK", "Idle"}};

    public TestInvoker(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
        Sigar sigar = new Sigar();
        SigarProxy proxy = SigarProxyCache.newInstance(sigar);
        this.testOK(proxy);
        sigar.close();
    }

    private void testOK(SigarProxy proxy) throws Exception {
        SigarInvokerJMX invoker;
        String[] query;
        int i;
        for (i = 0; i < OK_QUERIES.length; ++i) {
            query = OK_QUERIES[i];
            invoker = SigarInvokerJMX.getInstance(proxy, query[0]);
            try {
                Object o = invoker.invoke(query[1]);
                this.traceln(query[0] + ":" + query[1] + "=" + o);
                TestInvoker.assertTrue((boolean)true);
                continue;
            }
            catch (SigarNotImplementedException e) {
                this.traceln(query[0] + " NotImplemented");
                continue;
            }
            catch (SigarException e) {
                this.traceln(query[0] + ":" + query[1] + "=" + e.getMessage());
                TestInvoker.assertTrue((boolean)false);
            }
        }
        for (i = 0; i < BROKEN_QUERIES.length; ++i) {
            query = BROKEN_QUERIES[i];
            invoker = SigarInvokerJMX.getInstance(proxy, query[0]);
            try {
                invoker.invoke(query[1]);
                TestInvoker.assertTrue((boolean)false);
                continue;
            }
            catch (SigarException e) {
                this.traceln(query[0] + ":" + query[1] + "=" + e.getMessage());
                TestInvoker.assertTrue((boolean)true);
            }
        }
    }
}

