/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class Service
extends Win32 {
    public static final int SERVICE_STOPPED = 1;
    public static final int SERVICE_START_PENDING = 2;
    public static final int SERVICE_STOP_PENDING = 3;
    public static final int SERVICE_RUNNING = 4;
    public static final int SERVICE_CONTINUE_PENDING = 5;
    public static final int SERVICE_PAUSE_PENDING = 6;
    public static final int SERVICE_PAUSED = 7;
    private static final String[] STATUS = new String[]{"Unknown", "Stopped", "Start Pending", "Stop Pending", "Running", "Continue Pending", "Pause Pending", "Paused"};
    private static final int CONTROL_START = 0;
    private static final int CONTROL_STOP = 1;
    private static final int CONTROL_PAUSE = 2;
    private static final int CONTROL_RESUME = 3;
    private static final int STANDARD_RIGHTS_REQUIRED = 983040;
    private static final int SC_MANAGER_CONNECT = 1;
    private static final int SC_MANAGER_CREATE_SERVICE = 2;
    private static final int SC_MANAGER_ENUMERATE_SERVICE = 4;
    private static final int SC_MANAGER_LOCK = 8;
    private static final int SC_MANAGER_QUERY_LOCK_STATUS = 16;
    private static final int SC_MANAGER_MODIFY_BOOT_CONFIG = 32;
    private static final int SC_MANAGER_ALL_ACCESS = 983103;
    private static final int SERVICE_QUERY_CONFIG = 1;
    private static final int SERVICE_CHANGE_CONFIG = 2;
    private static final int SERVICE_QUERY_STATUS = 4;
    private static final int SERVICE_ENUMERATE_DEPENDENTS = 8;
    private static final int SERVICE_START = 16;
    private static final int SERVICE_STOP = 32;
    private static final int SERVICE_PAUSE_CONTINUE = 64;
    private static final int SERVICE_INTERROGATE = 128;
    private static final int SERVICE_USER_DEFINED_CONTROL = 256;
    private static final int SERVICE_ALL_ACCESS = 983551;
    private long manager = Service.OpenSCManager("", 983103);
    private long service;
    private String name;

    private Service() throws Win32Exception {
    }

    public static native List getServiceNames() throws Win32Exception;

    public static List getServiceConfigs(String exe) throws Win32Exception {
        return Service.getServiceConfigs(new ExeFilter(exe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getServiceConfigs(FileFilter filter) throws Win32Exception {
        ArrayList<ServiceConfig> services = new ArrayList<ServiceConfig>();
        List names = Service.getServiceNames();
        for (int i = 0; i < names.size(); ++i) {
            Service service = null;
            try {
                service = new Service((String)names.get(i));
                ServiceConfig config = service.getConfig();
                String path = config.getExe();
                if (path == null || !filter.accept(new File(path.trim()))) continue;
                services.add(config);
                continue;
            }
            catch (Win32Exception e) {
                continue;
            }
            finally {
                if (service != null) {
                    service.close();
                }
            }
        }
        return services;
    }

    public Service(String serviceName) throws Win32Exception {
        this();
        this.service = Service.OpenService(this.manager, serviceName, 983551);
        this.name = serviceName;
    }

    protected void finalize() {
        this.close();
    }

    public synchronized void close() {
        if (this.service != 0L) {
            Service.CloseServiceHandle(this.service);
            this.service = 0L;
        }
        if (this.manager != 0L) {
            Service.CloseServiceHandle(this.manager);
            this.manager = 0L;
        }
    }

    public static Service create(ServiceConfig config) throws Win32Exception {
        if (config.getName() == null) {
            throw new IllegalArgumentException("name=null");
        }
        if (config.getPath() == null) {
            throw new IllegalArgumentException("path=null");
        }
        Service service = new Service();
        service.service = Service.CreateService(service.manager, config.getName(), config.getDisplayName(), config.getType(), config.getStartType(), config.getErrorControl(), config.getPath(), config.getDependencies(), config.getStartName(), config.getPassword());
        if (config.getDescription() != null) {
            service.setDescription(config.getDescription());
        }
        return service;
    }

    public void delete() throws Win32Exception {
        Service.DeleteService(this.service);
    }

    public void setDescription(String description) {
        Service.ChangeServiceDescription(this.service, description);
    }

    public int status() {
        return this.getStatus();
    }

    public int getStatus() {
        return Service.QueryServiceStatus(this.service);
    }

    public String getStatusString() {
        return STATUS[this.getStatus()];
    }

    private void control(int ctl) throws Win32Exception {
        Service.ControlService(this.service, ctl);
    }

    public void stop() throws Win32Exception {
        this.control(1);
    }

    public void stopAndWait(long timeout) throws Win32Exception {
        this.stop(timeout);
    }

    public void stop(long timeout) throws Win32Exception {
        this.stop();
        Waiter waiter = new Waiter(this, timeout, 1, 3);
        if (!waiter.sleep()) {
            throw new Win32Exception("Failed to stop service");
        }
    }

    public void start() throws Win32Exception {
        this.control(0);
    }

    public void start(long timeout) throws Win32Exception {
        this.start();
        Waiter waiter = new Waiter(this, timeout, 4, 2);
        if (!waiter.sleep()) {
            throw new Win32Exception("Failed to start service");
        }
    }

    public void pause() throws Win32Exception {
        this.control(2);
    }

    public void pause(long timeout) throws Win32Exception {
        this.pause();
        Waiter waiter = new Waiter(this, timeout, 7, 6);
        if (!waiter.sleep()) {
            throw new Win32Exception("Failed to pause service");
        }
    }

    public void resume() throws Win32Exception {
        this.control(3);
    }

    public ServiceConfig getConfig() throws Win32Exception {
        ServiceConfig config = new ServiceConfig();
        Service.QueryServiceConfig(this.service, config);
        config.setName(this.name);
        return config;
    }

    private static native boolean ChangeServiceDescription(long var0, String var2);

    private static native boolean CloseServiceHandle(long var0);

    private static native long CreateService(long var0, String var2, String var3, int var4, int var5, int var6, String var7, String[] var8, String var9, String var10) throws Win32Exception;

    private static native void ControlService(long var0, int var2) throws Win32Exception;

    private static native void DeleteService(long var0) throws Win32Exception;

    private static native long OpenSCManager(String var0, int var1) throws Win32Exception;

    private static native long OpenService(long var0, String var2, int var3) throws Win32Exception;

    private static native int QueryServiceStatus(long var0);

    private static native boolean QueryServiceConfig(long var0, ServiceConfig var2) throws Win32Exception;

    public void list(PrintStream out) throws Win32Exception {
        this.getConfig().list(out);
        out.println("status........[" + this.getStatusString() + "]");
    }

    public static void main(String[] args) throws Exception {
        List<String> services;
        if (args.length == 0) {
            services = Service.getServiceNames();
        } else {
            if (args.length == 2 && args[0].equals("-toggle")) {
                long timeout = 5000L;
                Service service = new Service(args[1]);
                if (service.getStatus() == 4) {
                    System.out.println("Stopping service...");
                    service.stop(timeout);
                } else {
                    System.out.println("Starting service...");
                    service.start(timeout);
                }
                System.out.println(service.getStatusString());
                return;
            }
            if (args.length == 1 && args[0].endsWith(".exe")) {
                List services2 = Service.getServiceConfigs(args[0]);
                for (int i = 0; i < services2.size(); ++i) {
                    ServiceConfig config = (ServiceConfig)services2.get(i);
                    config.list(System.out);
                    System.out.println("");
                }
                return;
            }
            services = Arrays.asList(args);
        }
        for (int i = 0; i < services.size(); ++i) {
            String name = services.get(i);
            Service service = new Service(name);
            service.list(System.out);
            System.out.println("");
        }
    }

    private static class Waiter {
        long start = System.currentTimeMillis();
        Service service;
        long timeout;
        int wantedState;
        int pendingState;

        Waiter(Service service, long timeout, int wantedState, int pendingState) {
            this.service = service;
            this.timeout = timeout;
            this.wantedState = wantedState;
            this.pendingState = pendingState;
        }

        boolean sleep() {
            int status;
            while ((status = this.service.getStatus()) != this.wantedState) {
                if (status != this.pendingState) {
                    return false;
                }
                if (this.timeout > 0L && System.currentTimeMillis() - this.start >= this.timeout) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return status == this.wantedState;
        }
    }

    private static class ExeFilter
    implements FileFilter {
        private String name;

        private ExeFilter(String name) {
            this.name = name.toLowerCase();
        }

        public boolean accept(File file) {
            return this.name.equals(file.getName().toLowerCase());
        }
    }
}

