/*
 * Copyright (C) [2004, 2005, 2006], Hyperic, Inc.
 * This file is part of SIGAR.
 * 
 * SIGAR is free software; you can redistribute it and/or modify
 * it under the terms version 2 of the GNU General Public License as
 * published by the Free Software Foundation. This program is distributed
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

package org.hyperic.sigar.cmd.vmware;

import java.io.IOException;
import java.util.ArrayList;

import org.hyperic.sigar.SigarException;

import org.hyperic.sigar.util.GetlineCompleter;

import org.hyperic.sigar.cmd.Shell;

import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.MultiwordShellCommand;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandUsageException;

import org.hyperic.sigar.vmware.VMControlLibrary;

public class VMware
    extends MultiwordShellCommand
    implements GetlineCompleter {

    private Shell shell;
    private GetlineCompleter m_completer;

    private VMware() { }

    public VMware(Shell shell) {
        this.shell = shell;
    }

    public String complete(String line) {
        //XXX
        return line;
    }

    public void init(String commandName, ShellBase shell)
        throws ShellCommandInitException
    {
        ShellCommandHandler handler;

        super.init(commandName, shell);

        handler = new VMware_list(this.shell);
        registerSubHandler("-l", handler);

        this.m_completer =
            new CollectionCompleter(shell, getHandlerNames());
    }

    public String getSyntaxArgs() {
        return "XXX";
    }

    public String getUsageShort() {
        return "Run VMware command";
    }

    public void processCommand(String[] args) 
        throws ShellCommandUsageException, ShellCommandExecException 
    {
        try {
            VMControlLibrary.link();
        } catch (IOException e) {
            throw new ShellCommandExecException(e.getMessage());
        }

        if (!VMControlLibrary.isLoaded()) {
            throw new ShellCommandExecException("Library not available");
        }
    }
}
