/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import org.hyperic.jni.ArchNotSupportedException;

public class ArchName {
    static boolean useDmalloc = System.getProperty("jni.dmalloc") != null;

    public static String getName() throws ArchNotSupportedException {
        String name = ArchName.getArchName();
        if (useDmalloc) {
            name = name + "-dmalloc";
        }
        return name;
    }

    public static boolean is64() {
        return "64".equals(System.getProperty("sun.arch.data.model"));
    }

    private static String getArchName() throws ArchNotSupportedException {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        String majorVersion = version.substring(0, 1);
        if (arch.endsWith("86")) {
            arch = "x86";
        }
        if (name.equals("Linux")) {
            return arch + "-linux";
        }
        if (name.indexOf("Windows") > -1) {
            return arch + "-winnt";
        }
        if (name.equals("SunOS")) {
            if (arch.startsWith("sparcv") && ArchName.is64()) {
                arch = "sparc64";
            }
            return arch + "-solaris";
        }
        if (name.equals("HP-UX")) {
            arch = arch.startsWith("IA64") ? "ia64" : "pa";
            if (version.indexOf("11") > -1) {
                return arch + "-hpux-11";
            }
        } else {
            if (name.equals("AIX")) {
                return "ppc-aix-" + majorVersion;
            }
            if (name.equals("Mac OS X")) {
                return "universal-macosx";
            }
            if (name.equals("FreeBSD")) {
                return arch + "-freebsd-" + majorVersion;
            }
            if (name.equals("OpenBSD")) {
                return arch + "-openbsd-" + majorVersion;
            }
            if (name.equals("NetBSD")) {
                return arch + "-netbsd-" + majorVersion;
            }
            if (name.equals("OSF1")) {
                return "alpha-osf1-" + majorVersion;
            }
            if (name.equals("NetWare")) {
                return "x86-netware-" + majorVersion;
            }
        }
        String desc = arch + "-" + name + "-" + version;
        throw new ArchNotSupportedException("platform (" + desc + ") not supported");
    }

    private ArchName() {
    }
}

