/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import org.hyperic.sigar.Cpu;

public class CpuPerc
implements Serializable {
    private static final long serialVersionUID = 607239L;
    private double user;
    private double sys;
    private double nice;
    private double idle;
    private double wait;

    CpuPerc() {
    }

    public static CpuPerc calculate(Cpu oldCpu, Cpu curCpu) {
        double diffUser = curCpu.getUser() - oldCpu.getUser();
        double diffSys = curCpu.getSys() - oldCpu.getSys();
        double diffNice = curCpu.getNice() - oldCpu.getNice();
        double diffIdle = curCpu.getIdle() - oldCpu.getIdle();
        double diffWait = curCpu.getWait() - oldCpu.getWait();
        diffUser = diffUser < 0.0 ? 0.0 : diffUser;
        diffSys = diffSys < 0.0 ? 0.0 : diffSys;
        diffNice = diffNice < 0.0 ? 0.0 : diffNice;
        diffIdle = diffIdle < 0.0 ? 0.0 : diffIdle;
        diffWait = diffWait < 0.0 ? 0.0 : diffWait;
        double diffTotal = diffUser + diffSys + diffNice + diffIdle + diffWait;
        CpuPerc perc = new CpuPerc();
        perc.user = diffUser / diffTotal;
        perc.sys = diffSys / diffTotal;
        perc.nice = diffNice / diffTotal;
        perc.idle = diffIdle / diffTotal;
        perc.wait = diffWait / diffTotal;
        return perc;
    }

    public double getUser() {
        return this.user;
    }

    public double getSys() {
        return this.sys;
    }

    public double getNice() {
        return this.nice;
    }

    public double getIdle() {
        return this.idle;
    }

    public double getWait() {
        return this.wait;
    }

    public double getCombined() {
        return this.user + this.sys + this.nice + this.wait;
    }

    public static String format(double val) {
        String p = String.valueOf(val * 100.0);
        int ix = p.indexOf(".") + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent + "%";
    }

    public String toString() {
        return "CPU states: " + CpuPerc.format(this.user) + " user, " + CpuPerc.format(this.sys) + " system, " + CpuPerc.format(this.nice) + " nice, " + CpuPerc.format(this.wait) + " wait, " + CpuPerc.format(this.idle) + " idle";
    }
}

