/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessFinder;

public class MultiProcCpu
extends ProcCpu {
    private long pid;
    private int nproc = 0;
    private static Map ptable = new HashMap();

    static synchronized MultiProcCpu get(Sigar sigar, String query) throws SigarException {
        long timeNow;
        double diff;
        MultiProcCpu cpu = (MultiProcCpu)ptable.get(query);
        if (cpu == null) {
            cpu = new MultiProcCpu();
            cpu.pid = query.hashCode();
            ptable.put(query, cpu);
        }
        if ((diff = (double)((timeNow = System.currentTimeMillis()) - cpu.lastTime)) == 0.0) {
            return cpu;
        }
        cpu.lastTime = timeNow;
        long otime = cpu.total;
        cpu.total = 0L;
        cpu.user = 0L;
        cpu.sys = 0L;
        cpu.nproc = 0;
        long[] pids = ProcessFinder.find(sigar, query);
        cpu.nproc = pids.length;
        for (int i = 0; i < pids.length; ++i) {
            ProcTime time = sigar.getProcTime(pids[i]);
            cpu.total += time.total;
            cpu.user += time.user;
            cpu.sys += time.sys;
        }
        if (otime == 0L) {
            return cpu;
        }
        cpu.percent = (double)(cpu.total - otime) / diff;
        if (cpu.percent < 0.0) {
            cpu.percent = 0.0 - cpu.percent;
        }
        if (cpu.percent >= 1.0) {
            cpu.percent = 0.99;
        }
        return cpu;
    }

    public double getPercent() {
        return this.percent;
    }

    public int getProcesses() {
        return this.nproc;
    }

    public int hashCode() {
        return (int)this.pid;
    }

    public boolean equals(Object cpu) {
        if (!(cpu instanceof MultiProcCpu)) {
            return false;
        }
        return ((MultiProcCpu)cpu).pid == this.pid;
    }
}

