/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestFileSystem
extends SigarTestCase {
    public TestFileSystem(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        FileSystem[] fslist = sigar.getFileSystemList();
        FileSystemMap mounts = sigar.getFileSystemMap();
        String dir = System.getProperty("user.home");
        this.assertTrueTrace("\nMountPoint for " + dir, mounts.getMountPoint(dir).getDirName());
        for (int i = 0; i < fslist.length; ++i) {
            FileSystemUsage usage;
            FileSystem fs = fslist[i];
            TestFileSystem.assertTrue((mounts.getFileSystem(fs.getDirName()) != null ? 1 : 0) != 0);
            this.assertLengthTrace("DevName", fs.getDevName());
            this.assertLengthTrace("DirName", fs.getDirName());
            this.assertLengthTrace("TypeName", fs.getTypeName());
            this.assertLengthTrace("SysTypeName", fs.getSysTypeName());
            try {
                usage = sigar.getFileSystemUsage(fs.getDirName());
            }
            catch (SigarException e) {
                if (fs.getType() != 2) continue;
                throw e;
            }
            switch (fs.getType()) {
                case 2: {
                    this.assertGtZeroTrace("  Total", usage.getTotal());
                    this.assertGtEqZeroTrace("  Free", usage.getFree());
                    this.assertGtEqZeroTrace("  Avail", usage.getAvail());
                    this.assertGtEqZeroTrace("   Used", usage.getUsed());
                    double usePercent = usage.getUsePercent() * 100.0;
                    this.traceln("  Usage=" + usePercent + "%");
                    TestFileSystem.assertTrue((usePercent <= 100.0 ? 1 : 0) != 0);
                }
            }
            this.traceln("  DiskReads=" + usage.getDiskReads());
            this.traceln("  DiskWrites=" + usage.getDiskWrites());
        }
        try {
            sigar.getFileSystemUsage("T O T A L L Y B O G U S");
            TestFileSystem.assertTrue((boolean)false);
        }
        catch (SigarException e) {
            TestFileSystem.assertTrue((boolean)true);
        }
    }
}

