/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.$guava$.base.$Functions;
import org.immutables.value.internal.$guava$.collect.$FluentIterable;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.encode.$Instantiator;
import org.immutables.value.internal.$processor$.meta.$DefaultAnnotations;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

final class $FactoryMethodAttributesCollector {
    private final $Proto.Protoclass protoclass;
    private final $ValueType type;
    private final List<$ValueAttribute> attributes = $Lists.newArrayList();
    private final $Styles styles;
    private final $Reporter reporter;

    $FactoryMethodAttributesCollector($Proto.Protoclass protoclass, $ValueType type) {
        this.protoclass = protoclass;
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
    }

    void collect() {
        ExecutableElement factoryMethodElement = (ExecutableElement)this.protoclass.sourceElement();
        Parameterizable element = (Parameterizable)(factoryMethodElement.getKind() == ElementKind.CONSTRUCTOR ? factoryMethodElement.getEnclosingElement() : this.type.element);
        for (VariableElement variableElement : factoryMethodElement.getParameters()) {
            TypeMirror returnType = variableElement.asType();
            $ValueAttribute attribute = new $ValueAttribute();
            attribute.isGenerateAbstract = true;
            attribute.reporter = this.reporter;
            attribute.returnType = returnType;
            attribute.element = variableElement;
            String parameterName = variableElement.getSimpleName().toString();
            attribute.names = this.styles.forAccessorWithRaw(parameterName, parameterName);
            attribute.constantDefault = $DefaultAnnotations.extractConstantDefault(this.reporter, variableElement, returnType);
            if (attribute.constantDefault != null) {
                attribute.isGenerateDefault = true;
            }
            attribute.containingType = this.type;
            this.attributes.add(attribute);
        }
        $Instantiator encodingInstantiator = this.protoclass.encodingInstantiator();
        $Instantiator.InstantiationCreator instantiationCreator = encodingInstantiator.creatorFor(element);
        for ($ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate(instantiationCreator);
        }
        if (instantiationCreator != null) {
            this.type.additionalImports(instantiationCreator.imports);
        }
        this.type.attributes.addAll(this.attributes);
        this.type.throwing = $FactoryMethodAttributesCollector.extractThrowsClause(factoryMethodElement);
    }

    private static $ImmutableList<String> extractThrowsClause(ExecutableElement factoryMethodElement) {
        return $FluentIterable.from(factoryMethodElement.getThrownTypes()).transform($Functions.toStringFunction()).toList();
    }

    private $Reporter report(Element type) {
        return $Reporter.from(this.protoclass.processing()).withElement(type);
    }
}

