/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.infinispan.Cache;
import org.infinispan.all.embeddedquery.AbstractQueryTest;
import org.infinispan.all.embeddedquery.testdomain.Car;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleFacetingTest
extends AbstractQueryTest {
    private static final String indexFieldName = "cubicCapacity";
    private static final String facetName = "ccs";
    private static SearchManager qf;

    @BeforeClass
    public static void prepareSearchFactory() throws Exception {
        cache = SimpleFacetingTest.createCacheManager().getCache();
        qf = Search.getSearchManager((Cache)cache);
        cache.put((Object)"195 Inter", (Object)new Car("Ferrari 195 Inter", "Rosso corsa", 2341));
        cache.put((Object)"212 Inter", (Object)new Car("Ferrari 212 Inter", "black", 4000));
        cache.put((Object)"500_Superfast", (Object)new Car("Ferrari 500_Superfast", "Rosso corsa", 4000));
        cache.put((Object)"500_Superfast", (Object)new Car("Ferrari 500_Superfast", "Rosso corsa", 4000));
    }

    @AfterClass
    public static void cleanupData() {
        cache.clear();
    }

    @Test
    public void testFaceting() throws Exception {
        QueryBuilder queryBuilder = qf.buildQueryBuilderForClass(Car.class).get();
        FacetingRequest request = queryBuilder.facet().name(facetName).onField(indexFieldName).discrete().createFacetingRequest();
        Query luceneQuery = queryBuilder.all().createQuery();
        CacheQuery query = qf.getQuery(luceneQuery, new Class[0]);
        query.getFacetManager().enableFaceting(request);
        List facetList = query.getFacetManager().getFacets(facetName);
        Assert.assertEquals((String)"Wrong number of facets", (long)2L, (long)facetList.size());
        Assert.assertEquals((Object)"4000", (Object)((Facet)facetList.get(0)).getValue());
        Assert.assertEquals((long)2L, (long)((Facet)facetList.get(0)).getCount());
        Assert.assertEquals((Object)indexFieldName, (Object)((Facet)facetList.get(0)).getFieldName());
        Assert.assertEquals((Object)"2341", (Object)((Facet)facetList.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((Facet)facetList.get(1)).getCount());
        Assert.assertEquals((Object)indexFieldName, (Object)((Facet)facetList.get(1)).getFieldName());
    }
}

