/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.app_config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.javalite.app_config.ConfigInitException;
import org.javalite.app_config.Property;
import org.javalite.common.Convert;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig
implements Map<String, String> {
    private static Logger LOGGER = LoggerFactory.getLogger(AppConfig.class);
    private static HashMap<String, Property> props;
    private static String activeEnv;

    public static void setActiveEnv(String activeEnv) {
        AppConfig.activeEnv = activeEnv;
    }

    public static synchronized void init() {
        if (!AppConfig.isInited()) {
            AppConfig.reload();
        }
    }

    public static void reload() {
        try {
            props = new HashMap();
            AppConfig.loadFromClasspath();
            String propName = "app_config.properties";
            if (System.getProperties().containsKey(propName)) {
                AppConfig.loadFromFileSystem(System.getProperty(propName));
            }
            AppConfig.merge();
        }
        catch (ConfigInitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigInitException(e);
        }
    }

    private static void merge() {
        Set<String> keySet = props.keySet();
        for (Property property : props.values()) {
            for (String key : keySet) {
                String val;
                if (key.equals(property.getName()) || !(val = property.getValue()).contains("${" + key + "}")) continue;
                property.setValue(val.replaceAll("\\$\\{" + key + "\\}", AppConfig.p(key)));
            }
        }
    }

    private static void loadFromFileSystem(String filePath) throws MalformedURLException {
        File f = new File(filePath);
        if (!f.exists() || f.isDirectory()) {
            throw new ConfigInitException("failed to find file: " + filePath);
        }
        AppConfig.registerProperties(f.toURI().toURL());
    }

    private static void loadFromClasspath() {
        String file;
        URL url;
        URL globalUrl = AppConfig.class.getResource("/app_config/global.properties");
        if (globalUrl != null) {
            AppConfig.registerProperties(globalUrl);
        }
        if ((url = AppConfig.class.getResource(file = "/app_config/" + AppConfig.activeEnv() + ".properties")) == null) {
            LOGGER.warn("Property file not found: '" + file + "'");
        } else {
            AppConfig.registerProperties(url);
        }
    }

    private static boolean isInited() {
        return props != null;
    }

    private static void registerProperties(URL url) {
        LOGGER.info("Registering properties from: " + url.getPath());
        Properties temp = new Properties();
        try {
            temp.load(url.openStream());
        }
        catch (IOException e) {
            throw new ConfigInitException(e);
        }
        Enumeration<Object> keys = temp.keys();
        while (keys.hasMoreElements()) {
            String value;
            Property property;
            String key = (String)keys.nextElement();
            Property previous = props.put(key, property = new Property(key, value = temp.getProperty(key), url.getPath()));
            if (previous == null) continue;
            LOGGER.warn("Duplicate property defined. Property: '" + key + "' found in files:" + previous.getPropertyFile() + ", " + url.getPath() + ", Using value '" + property.getValue() + "' from:" + property.getPropertyFile());
        }
    }

    public static String setProperty(String name, String value) {
        String val = null;
        if (props.containsKey(name)) {
            val = props.get(name).getValue();
        }
        props.put(name, new Property(name, value, "dynamically added"));
        LOGGER.warn("Temporary overriding property: " + name + ". Old value: " + val + ". New value: " + value);
        return val;
    }

    public static Property getAsProperty(String key) {
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        return props.get(key);
    }

    public static String getProperty(String key) {
        Property p;
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        return (p = props.get(key)) == null ? null : p.getValue();
    }

    public static String p(String key) {
        return AppConfig.getProperty(key);
    }

    public static Map<String, String> getAllProperties() {
        if (!AppConfig.isInited()) {
            AppConfig.init();
        }
        HashMap<String, String> plainProps = new HashMap<String, String>();
        for (String name : props.keySet()) {
            plainProps.put(name, props.get(name).getValue());
        }
        return plainProps;
    }

    @Override
    public int size() {
        return props.size();
    }

    @Override
    public boolean isEmpty() {
        return props.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return props.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return props.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return AppConfig.p(key.toString());
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Collection<String> values() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException("Operation not supported, not a real map");
    }

    public static String activeEnv() {
        return activeEnv;
    }

    public static boolean isInTestMode() {
        return Util.getStackTraceString((Throwable)new Exception()).contains("junit");
    }

    public static boolean isInTestEnv() {
        return "testenv".equals(AppConfig.activeEnv());
    }

    public static boolean isInProduction() {
        return "production".equals(AppConfig.activeEnv());
    }

    public static boolean isInDevelopment() {
        return "development".equals(AppConfig.activeEnv());
    }

    public static boolean isInStaging() {
        return "staging".equals(AppConfig.activeEnv());
    }

    public static List<String> getKeys(String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        for (String key : props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            res.add(key);
        }
        return res;
    }

    public static List<String> getProperties(String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        prefix = prefix + ".";
        int i = 1;
        String prop;
        while ((prop = AppConfig.p(prefix + i)) != null) {
            res.add(prop);
            ++i;
        }
        return res;
    }

    public static Integer pInteger(String propertyName) {
        return Convert.toInteger((Object)AppConfig.p(propertyName));
    }

    public static Double pDouble(String propertyName) {
        return Convert.toDouble((Object)AppConfig.p(propertyName));
    }

    public static Float pFloat(String propertyName) {
        return Convert.toFloat((Object)AppConfig.p(propertyName));
    }

    public static Boolean pBoolean(String propertyName) {
        return Convert.toBoolean((Object)AppConfig.p(propertyName));
    }

    static {
        String envVar = System.getenv("ACTIVE_ENV");
        String sysProp = System.getProperty("active_env");
        if (envVar == null && sysProp == null) {
            activeEnv = "development";
            LOGGER.warn("Environment variable 'ACTIVE_ENV' as well as system property `active_env` are not found, defaulting to 'development' environment.");
        } else if (sysProp != null) {
            activeEnv = sysProp;
            LOGGER.warn("Setting environment to: '" + activeEnv + "' from a system property 'active_env'.");
        } else if (envVar != null) {
            activeEnv = envVar;
            LOGGER.warn("Setting environment to: '" + activeEnv + "' from an environment variable '" + envVar + "'.");
        }
        AppConfig.init();
    }
}

