/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeUtil.class);

    public static Response execute(String ... command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            String out = Util.read(process.getInputStream());
            String err = Util.read(process.getErrorStream());
            LOGGER.info("Command \"{}\" finished with the a response '{}' and error '{}'.", new Object[]{Util.join(command, " "), out, err});
            if (process.waitFor() != 0) {
                throw new RuntimeException("Failed to execute command: " + Util.join(command, " ") + "\n" + err);
            }
            return new Response(out, err);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Response {
        public final String out;
        public final String err;

        public Response(String out, String err) {
            this.out = out;
            this.err = err;
        }
    }
}

