/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.javalite.http.Delete;
import org.javalite.http.Get;
import org.javalite.http.HttpException;
import org.javalite.http.Multipart;
import org.javalite.http.Patch;
import org.javalite.http.Post;
import org.javalite.http.Put;

public class Http {
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int READ_TIMEOUT = 5000;

    private Http() {
    }

    public static Post post(String uri, String content) {
        return Http.post(uri, content.getBytes(), 5000, 5000);
    }

    public static Post post(String uri) {
        return Http.post(uri, null, 5000, 5000);
    }

    public static Post post(String uri, byte[] content) {
        return Http.post(uri, content, 5000, 5000);
    }

    public static Post post(String url, byte[] content, int connectTimeout, int readTimeout) {
        try {
            return new Post(url, content, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Post post(String url, int connectTimeout, int readTimeout) {
        try {
            return new Post(url, null, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Get get(String url) {
        return Http.get(url, 5000, 5000);
    }

    public static Get get(String url, int connectTimeout, int readTimeout) {
        try {
            return new Get(url, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Put put(String uri, String content) {
        return Http.put(uri, content.getBytes());
    }

    public static Put put(String uri, byte[] content) {
        return Http.put(uri, content, 5000, 5000);
    }

    public static Put put(String url, byte[] content, int connectTimeout, int readTimeout) {
        try {
            return new Put(url, content, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Multipart multipart(String url) {
        return new Multipart(url, 5000, 5000);
    }

    public static Multipart multipart(String url, int connectTimeout, int readTimeout) {
        return new Multipart(url, connectTimeout, connectTimeout);
    }

    public static Delete delete(String uri) {
        return Http.delete(uri, 5000, 5000);
    }

    public static Delete delete(String url, int connectTimeout, int readTimeout) {
        try {
            return new Delete(url, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Patch patch(String uri, String content) {
        return Http.patch(uri, content.getBytes(), 5000, 5000);
    }

    public static Patch patch(String uri, byte[] content) {
        return Http.patch(uri, content, 5000, 5000);
    }

    public static Patch patch(String url, byte[] content, int connectTimeout, int readTimeout) {
        try {
            return new Patch(url, content, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static String map2Content(Map params) {
        return Http.map2URLEncoded(params);
    }

    public static String map2URLEncoded(Map params) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set keySet = params.keySet();
            Object[] keys = keySet.toArray();
            for (int i = 0; i < keys.length; ++i) {
                stringBuilder.append(URLEncoder.encode(keys[i].toString(), "UTF-8")).append("=").append(URLEncoder.encode(params.get(keys[i]).toString(), "UTF-8"));
                if (i >= keys.length - 1) continue;
                stringBuilder.append("&");
            }
        }
        catch (Exception e) {
            throw new HttpException("failed to generate content from map", e);
        }
        return stringBuilder.toString();
    }
}

