/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader;

import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.test.AndroidTestCase;
import java.util.HashMap;
import junit.framework.Assert;
import org.jboss.aerogear.android.authentication.impl.loader.AbstractAuthenticationLoader;
import org.jboss.aerogear.android.authentication.impl.loader.AuthenticationModuleAdapter;
import org.jboss.aerogear.android.authentication.impl.loader.LoginLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;
import org.mockito.Mockito;

public class AuthenticationCallbackTest
extends AndroidTestCase {
    public void testPassModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(fragment, this.getContext(), null, "ignore");
        UnitTestUtils.setPrivateField(adapter, "manager", Mockito.mock(LoaderManager.class));
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        LoginLoader loader = (LoginLoader)Mockito.mock(LoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        AuthenticationModuleAdapter.CallbackHandler handler = new AuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractAuthenticationLoader)loader, data);
        handler.run();
        AuthenticationCallbackTest.assertTrue((boolean)fragmentCallback.successCalled);
        AuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testFailModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(fragment, this.getContext(), null, "ignore");
        UnitTestUtils.setPrivateField(adapter, "manager", Mockito.mock(LoaderManager.class));
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        LoginLoader loader = (LoginLoader)Mockito.mock(LoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        AuthenticationModuleAdapter.CallbackHandler handler = new AuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractAuthenticationLoader)loader, data);
        handler.run();
        AuthenticationCallbackTest.assertTrue((boolean)fragmentCallback.failCalled);
        AuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testPassModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(activity, null, "ignore");
        UnitTestUtils.setPrivateField(adapter, "manager", Mockito.mock(LoaderManager.class));
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        LoginLoader loader = (LoginLoader)Mockito.mock(LoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        AuthenticationModuleAdapter.CallbackHandler handler = new AuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractAuthenticationLoader)loader, data);
        handler.run();
        AuthenticationCallbackTest.assertTrue((boolean)activityCallback.successCalled);
        AuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    public void testFailModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        AuthenticationModuleAdapter adapter = new AuthenticationModuleAdapter(activity, null, "ignore");
        UnitTestUtils.setPrivateField(adapter, "manager", Mockito.mock(LoaderManager.class));
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        LoginLoader loader = (LoginLoader)Mockito.mock(LoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        AuthenticationModuleAdapter.CallbackHandler handler = new AuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractAuthenticationLoader)loader, data);
        handler.run();
        AuthenticationCallbackTest.assertTrue((boolean)activityCallback.failCalled);
        AuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    private static class VoidActivityCallback
    extends AbstractActivityCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidActivityCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getActivity());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getActivity());
            this.failCalled = true;
        }
    }

    private static class VoidFragmentCallback
    extends AbstractFragmentCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getFragment());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragment());
            this.failCalled = true;
        }
    }
}

