/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader;

import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.os.Bundle;
import android.test.AndroidTestCase;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.AuthenticationModuleAdapter;
import org.jboss.aerogear.android.impl.util.VoidCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AuthenticationLoaderAdapterTest
extends AndroidTestCase {
    private static String USERNAME_VALUE = "testUsername";
    private static String PASSWORD_VALUE = "testPassword";
    private Activity activity;
    private Fragment fragment;
    private LoaderManager manager;
    private ArgumentCaptor<Integer> idMatcher;
    private ArgumentCaptor<Bundle> bundleMatcher;
    private VoidCallback callback;
    private AuthenticationModule module = (AuthenticationModule)Mockito.mock(AuthenticationModule.class);

    protected void setUp() throws Exception {
        super.setUp();
        this.activity = (Activity)Mockito.mock(Activity.class);
        this.fragment = (Fragment)Mockito.mock(Fragment.class);
        this.manager = (LoaderManager)Mockito.mock(LoaderManager.class);
        this.callback = new VoidCallback();
        this.idMatcher = ArgumentCaptor.forClass(Integer.class);
        this.bundleMatcher = ArgumentCaptor.forClass(Bundle.class);
        Mockito.when((Object)this.activity.getLoaderManager()).thenReturn((Object)this.manager);
        Mockito.when((Object)this.fragment.getLoaderManager()).thenReturn((Object)this.manager);
    }

    public void testActivityLogin() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.activity, this.module, "name");
        authModule.login(USERNAME_VALUE, PASSWORD_VALUE, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"LOGIN", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals((Object)USERNAME_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("loginName"));
        AuthenticationLoaderAdapterTest.assertEquals((Object)PASSWORD_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("password"));
    }

    public void testActivityEnroll() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.activity, null, "name");
        Map<String, String> userData = this.makeUserData();
        authModule.enroll(userData, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"ENROLL", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals(userData, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
    }

    public void testActivityLogout() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.activity, this.module, "name");
        authModule.logout((Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"LOGOUT", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals((Object)this.callback, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK"));
    }

    public void testFragmentLogin() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        authModule.login(USERNAME_VALUE, PASSWORD_VALUE, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"LOGIN", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals((Object)USERNAME_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("loginName"));
        AuthenticationLoaderAdapterTest.assertEquals((Object)PASSWORD_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("password"));
    }

    public void testFragmentEnroll() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        Map<String, String> userData = this.makeUserData();
        authModule.enroll(userData, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"ENROLL", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals(userData, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
    }

    public void testFragmentLogout() {
        AuthenticationModuleAdapter authModule = new AuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        authModule.logout((Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        AuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        AuthenticationLoaderAdapterTest.assertEquals((String)"LOGOUT", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        AuthenticationLoaderAdapterTest.assertEquals((Object)this.callback, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK"));
    }

    private Map<String, String> makeUserData() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME", USERNAME_VALUE);
        toReturn.put("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD", PASSWORD_VALUE);
        return toReturn;
    }
}

