/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader.support;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.test.AndroidTestCase;
import java.util.HashMap;
import junit.framework.Assert;
import org.jboss.aerogear.android.authentication.impl.loader.support.AbstractSupportAuthenticationLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportAuthenticationModuleAdapter;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportLoginLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.pipeline.support.AbstractFragmentActivityCallback;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;
import org.mockito.Mockito;

public class SupportAuthenticationCallbackTest
extends AndroidTestCase {
    public void testPassSupportFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        SupportAuthenticationModuleAdapter adapter = new SupportAuthenticationModuleAdapter(fragment, this.getContext(), null, "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        SupportLoginLoader loader = (SupportLoginLoader)Mockito.mock(SupportLoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        SupportAuthenticationModuleAdapter.CallbackHandler handler = new SupportAuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractSupportAuthenticationLoader)loader, data);
        handler.run();
        SupportAuthenticationCallbackTest.assertTrue((boolean)fragmentCallback.successCalled);
        SupportAuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testFailSupportFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        SupportAuthenticationModuleAdapter adapter = new SupportAuthenticationModuleAdapter(fragment, this.getContext(), null, "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        SupportLoginLoader loader = (SupportLoginLoader)Mockito.mock(SupportLoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        SupportAuthenticationModuleAdapter.CallbackHandler handler = new SupportAuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractSupportAuthenticationLoader)loader, data);
        handler.run();
        SupportAuthenticationCallbackTest.assertTrue((boolean)fragmentCallback.failCalled);
        SupportAuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testPassSupportActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        FragmentActivity activity = (FragmentActivity)Mockito.mock(FragmentActivity.class);
        SupportAuthenticationModuleAdapter adapter = new SupportAuthenticationModuleAdapter(activity, null, "ignore");
        VoidFragmentActivityCallback activityCallback = new VoidFragmentActivityCallback();
        SupportLoginLoader loader = (SupportLoginLoader)Mockito.mock(SupportLoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        SupportAuthenticationModuleAdapter.CallbackHandler handler = new SupportAuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractSupportAuthenticationLoader)loader, data);
        handler.run();
        SupportAuthenticationCallbackTest.assertTrue((boolean)activityCallback.successCalled);
        SupportAuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    public void testFailFragmentActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        FragmentActivity activity = (FragmentActivity)Mockito.mock(FragmentActivity.class);
        SupportAuthenticationModuleAdapter adapter = new SupportAuthenticationModuleAdapter(activity, null, "ignore");
        VoidFragmentActivityCallback activityCallback = new VoidFragmentActivityCallback();
        SupportLoginLoader loader = (SupportLoginLoader)Mockito.mock(SupportLoginLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        HeaderAndBody data = new HeaderAndBody(new byte[]{1, 2, 3, 4}, new HashMap());
        SupportAuthenticationModuleAdapter.CallbackHandler handler = new SupportAuthenticationModuleAdapter.CallbackHandler(adapter, (AbstractSupportAuthenticationLoader)loader, data);
        handler.run();
        SupportAuthenticationCallbackTest.assertTrue((boolean)activityCallback.failCalled);
        SupportAuthenticationCallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    private static class VoidFragmentActivityCallback
    extends AbstractFragmentActivityCallback<HeaderAndBody> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentActivityCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(HeaderAndBody data) {
            Assert.assertNotNull((Object)this.getFragmentActivity());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragmentActivity());
            this.failCalled = true;
        }
    }

    private static class VoidFragmentCallback
    extends AbstractSupportFragmentCallback<HeaderAndBody> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(HeaderAndBody data) {
            Assert.assertNotNull((Object)this.getFragment());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragment());
            this.failCalled = true;
        }
    }
}

