/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader.support;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.test.AndroidTestCase;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportAuthenticationModuleAdapter;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportEnrollLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportLoginLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportLogoutLoader;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.util.VoidCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SupportAuthenticationLoaderAdapterTest
extends AndroidTestCase {
    private static String USERNAME_VALUE = "testUsername";
    private static String PASSWORD_VALUE = "testPassword";
    private FragmentActivity activity;
    private Fragment fragment;
    private LoaderManager manager;
    private ArgumentCaptor<Integer> idMatcher;
    private ArgumentCaptor<Bundle> bundleMatcher;
    private VoidCallback callback;

    protected void setUp() throws Exception {
        super.setUp();
        this.activity = (FragmentActivity)Mockito.mock(FragmentActivity.class);
        this.fragment = (Fragment)Mockito.mock(Fragment.class);
        this.manager = (LoaderManager)Mockito.mock(LoaderManager.class);
        this.callback = new VoidCallback();
        this.idMatcher = ArgumentCaptor.forClass(Integer.class);
        this.bundleMatcher = ArgumentCaptor.forClass(Bundle.class);
        Mockito.when((Object)this.activity.getSupportLoaderManager()).thenReturn((Object)this.manager);
        Mockito.when((Object)this.activity.getApplicationContext()).thenReturn((Object)this.getContext());
        Mockito.when((Object)this.fragment.getLoaderManager()).thenReturn((Object)this.manager);
    }

    public void testCreateEnrollLoader() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        Bundle bundle = new Bundle();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("username", "new User name");
        SupportAuthenticationModuleAdapter.Methods method = SupportAuthenticationModuleAdapter.Methods.ENROLL;
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)method);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS", data);
        SupportEnrollLoader loader = (SupportEnrollLoader)authModule.onCreateLoader(-1, bundle);
        Map result = (Map)UnitTestUtils.getPrivateField(loader, "params");
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"new User name", (String)((String)result.get("username")));
    }

    public void testCreateLoginLoader() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        Bundle bundle = new Bundle();
        Bundle loginParams = new Bundle();
        loginParams.putString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME", USERNAME_VALUE);
        loginParams.putString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD", PASSWORD_VALUE);
        SupportAuthenticationModuleAdapter.Methods method = SupportAuthenticationModuleAdapter.Methods.LOGIN;
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)method);
        bundle.putBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS", loginParams);
        SupportLoginLoader loader = (SupportLoginLoader)authModule.onCreateLoader(-1, bundle);
        HashMap loginData = (HashMap)UnitTestUtils.getPrivateField(loader, "loginData");
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)USERNAME_VALUE, loginData.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME"));
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)PASSWORD_VALUE, loginData.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD"));
    }

    public void testCreateLogoutLoader() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        Bundle bundle = new Bundle();
        SupportAuthenticationModuleAdapter.Methods method = SupportAuthenticationModuleAdapter.Methods.LOGOUT;
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)method);
        SupportLogoutLoader loader = (SupportLogoutLoader)authModule.onCreateLoader(-1, bundle);
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)loader);
    }

    public void testActivityLogin() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        authModule.login(USERNAME_VALUE, PASSWORD_VALUE, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"LOGIN", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)USERNAME_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("loginName"));
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)PASSWORD_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("password"));
    }

    public void testActivityEnroll() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        Map<String, String> userData = this.makeUserData();
        authModule.enroll(userData, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"ENROLL", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals(userData, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
    }

    public void testActivityLogout() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.activity, null, "name");
        authModule.logout((Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"LOGOUT", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)this.callback, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK"));
    }

    public void testFragmentLogin() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        authModule.login(USERNAME_VALUE, PASSWORD_VALUE, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"LOGIN", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)USERNAME_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("loginName"));
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)PASSWORD_VALUE, (Object)bundle.getBundle("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS").get("password"));
    }

    public void testFragmentEnroll() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        Map<String, String> userData = this.makeUserData();
        authModule.enroll(userData, (Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"ENROLL", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals(userData, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
    }

    public void testFragmentLogout() {
        SupportAuthenticationModuleAdapter authModule = new SupportAuthenticationModuleAdapter(this.fragment, this.mContext, null, "name");
        authModule.logout((Callback)this.callback);
        ((LoaderManager)Mockito.verify((Object)this.manager)).initLoader(((Integer)this.idMatcher.capture()).intValue(), (Bundle)this.bundleMatcher.capture(), (LoaderManager.LoaderCallbacks)Matchers.any());
        Bundle bundle = (Bundle)this.bundleMatcher.getValue();
        SupportAuthenticationLoaderAdapterTest.assertNotNull((Object)bundle);
        SupportAuthenticationLoaderAdapterTest.assertEquals((String)"LOGOUT", (String)((Enum)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD")).name());
        SupportAuthenticationLoaderAdapterTest.assertEquals((Object)this.callback, (Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK"));
    }

    private Map<String, String> makeUserData() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME", USERNAME_VALUE);
        toReturn.put("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD", PASSWORD_VALUE);
        return toReturn;
    }
}

