/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.test;

import android.support.test.runner.AndroidJUnit4;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.android.authentication.AuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.AuthenticationManager;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.basic.HttpBasicAuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.digest.HttpDigestAuthenticationConfiguration;
import org.jboss.aerogear.android.authentication.test.MainActivity;
import org.jboss.aerogear.android.authentication.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AndroidJUnit4.class)
public class AuthenticatorManagerTest
extends PatchedActivityInstrumentationTestCase {
    private static final URL SIMPLE_URL;
    private static final String SIMPLE_MODULE_NAME = "simple";

    public AuthenticatorManagerTest() {
        super(MainActivity.class);
    }

    @Test
    public void testAddAuthenticatorFailsWithUnsupportedType() {
        try {
            AuthenticationManager.config((String)SIMPLE_MODULE_NAME, new AuthenticationConfiguration(){

                protected AuthenticationModule buildModule() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }.getClass());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSimpleAuthenticator() {
        AuthenticationManager.registerConfigurationProvider(DummAuthenticationConfiguration.class, (ConfigurationProvider)new DummyAuthenticationConfigProvider());
        AuthenticationConfiguration config = AuthenticationManager.config((String)"test", DummAuthenticationConfiguration.class);
        Assert.assertTrue((boolean)(config instanceof DummAuthenticationConfiguration));
    }

    @Test
    public void testAddAndGetSimpleAuthenticator() {
        AuthenticationConfiguration config = AuthenticationManager.config((String)SIMPLE_MODULE_NAME, HttpBasicAuthenticationConfiguration.class);
        AuthenticationModule simpleAuthModule = config.baseURL(SIMPLE_URL).asModule();
        Assert.assertEquals((Object)simpleAuthModule, (Object)AuthenticationManager.getModule((String)SIMPLE_MODULE_NAME));
    }

    @Test
    public void testNullBaseURLFails() {
        HttpDigestAuthenticationConfiguration config = (HttpDigestAuthenticationConfiguration)AuthenticationManager.config((String)SIMPLE_MODULE_NAME, HttpDigestAuthenticationConfiguration.class);
        try {
            config.asModule();
            Assert.fail((String)"Should not pass");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAuthenticator() {
        HttpDigestAuthenticationConfiguration config = (HttpDigestAuthenticationConfiguration)AuthenticationManager.config((String)SIMPLE_MODULE_NAME, HttpDigestAuthenticationConfiguration.class);
        AuthenticationModule simpleAuthModule = ((HttpDigestAuthenticationConfiguration)config.loginEndpoint("testLogin").logoutEndpoint("testLogout").baseURL(SIMPLE_URL)).asModule();
        Assert.assertEquals((Object)simpleAuthModule, (Object)AuthenticationManager.getModule((String)SIMPLE_MODULE_NAME));
        Assert.assertEquals((Object)"testLogin", (Object)simpleAuthModule.getLoginEndpoint());
        Assert.assertEquals((Object)"testLogout", (Object)simpleAuthModule.getLogoutEndpoint());
    }

    @Test
    public void testGetNullAuthModule() {
        Assert.assertNull((Object)AuthenticationManager.getModule((String)"nullModule"));
    }

    static {
        try {
            SIMPLE_URL = new URL("http", "localhost", 80, "/");
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AuthenticatorManagerTest.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private static class DummAuthenticationConfiguration
    extends AuthenticationConfiguration<DummAuthenticationConfiguration> {
        protected AuthenticationModule buildModule() {
            return null;
        }
    }

    private static final class DummyAuthenticationConfigProvider
    implements ConfigurationProvider<DummAuthenticationConfiguration> {
        private DummyAuthenticationConfigProvider() {
        }

        public DummAuthenticationConfiguration newConfiguration() {
            return new DummAuthenticationConfiguration();
        }
    }
}

