/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.OnAuthenticationCreatedListener;
import org.jboss.aerogear.android.core.Config;

public abstract class AuthenticationConfiguration<CONFIGURATION extends AuthenticationConfiguration<CONFIGURATION>>
implements Config<CONFIGURATION> {
    private String name;
    private URL baseURL;
    private Collection<OnAuthenticationCreatedListener> listeners = new HashSet<OnAuthenticationCreatedListener>();

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public Collection<OnAuthenticationCreatedListener> getOnAuthenticationCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnAuthenticationCreatedListener(OnAuthenticationCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnAuthenticationCreatedListeners(Collection<OnAuthenticationCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }

    public final AuthenticationModule asModule() {
        if (this.baseURL == null) {
            throw new IllegalStateException("baseURL may not be null");
        }
        AuthenticationModule newModule = this.buildModule();
        for (OnAuthenticationCreatedListener listener : this.getOnAuthenticationCreatedListeners()) {
            listener.onAuthenticationCreated(this, newModule);
        }
        return newModule;
    }

    protected abstract AuthenticationModule buildModule();

    public URL getBaseUrl() {
        return this.baseURL;
    }

    public CONFIGURATION baseURL(URL baseURL) {
        this.baseURL = baseURL;
        return (CONFIGURATION)this;
    }
}

