/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.digest;

import android.util.Log;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.digest.DigestAuthenticationModuleRunner;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.module.ModuleFields;

public class HttpDigestAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String TAG = HttpDigestAuthenticationModule.class.getSimpleName();
    private boolean isLoggedIn = false;
    private final DigestAuthenticationModuleRunner runner;

    public HttpDigestAuthenticationModule(URL baseURL, String loginEndpoint, String logoutEndpoint, Integer timeout) {
        this.runner = new DigestAuthenticationModuleRunner(baseURL, loginEndpoint, logoutEndpoint, timeout);
    }

    @Override
    public URL getBaseURL() {
        return this.runner.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.runner.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.runner.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.runner.getEnrollEndpoint();
    }

    @Override
    public void enroll(Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure((Exception)new UnsupportedOperationException());
            }
        });
    }

    @Override
    public void login(final String username, final String password, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = HttpDigestAuthenticationModule.this.runner.onLogin(username, password);
                    HttpDigestAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess((Object)result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    HttpDigestAuthenticationModule.this.runner.onLogout();
                    HttpDigestAuthenticationModule.this.isLoggedIn = false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public void login(Map<String, String> loginData, Callback<HeaderAndBody> callback) {
        this.login(loginData.get("loginName"), loginData.get("password"), callback);
    }

    public ModuleFields loadModule(URI relativeURI, String httpMethod, byte[] requestBody) {
        ModuleFields fields = new ModuleFields();
        fields.addHeader("Authorization", this.runner.getAuthorizationHeader(relativeURI, httpMethod, requestBody));
        return fields;
    }

    public boolean handleError(HttpException exception) {
        return this.isLoggedIn() && this.runner.retryLogin();
    }
}

