/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.gcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.test.runner.AndroidJUnit4;
import android.util.Log;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.GCMSharedPreferenceProvider;
import org.jboss.aerogear.android.unifiedpush.gcm.UnifiedPushConfig;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.unifiedpush.test.util.UnitTestUtils;
import org.jboss.aerogear.android.unifiedpush.test.util.VoidCallback;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=AndroidJUnit4.class)
public class AeroGearGCMPushRegistrarTest
extends PatchedActivityInstrumentationTestCase {
    private static final String TEST_SENDER_ID = "272275396485";
    private static final String TEST_REGISTRAR_PREFERENCES_KEY = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:272275396485";
    private static final String TEST_SENDER_PASSWORD = "Password";
    private static final String TEST_SENDER_VARIANT = "Variant";
    private static final String[] CATEGORIES = new String[]{"test", "anotherTest"};
    private static final String TAG = AeroGearGCMPushRegistrarTest.class.getSimpleName();

    public AeroGearGCMPushRegistrarTest() {
        super(MainActivity.class);
    }

    @Test
    public void testAsRegistrarFailsOnNullSenderId() throws URISyntaxException {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setPushServerURI(new URI("https://testuri"));
            config.asRegistrar();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"SenderId can't be null or empty", (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testAsRegistrarFailsOnNullPushServerURI() {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID);
            config.asRegistrar();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"PushServerURI can't be null", (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testRegister() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setCategories(CATEGORIES).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        VoidCallback callback = new VoidCallback(latch);
        final GcmPubSub mockPubSub = (GcmPubSub)Mockito.mock(GcmPubSub.class);
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).unsubscribe(Matchers.anyString(), Matchers.anyString());
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).subscribe(Matchers.anyString(), Matchers.anyString(), (Bundle)Matchers.any(Bundle.class));
        Provider<GcmPubSub> gcmPubSubProvider = new Provider<GcmPubSub>(){

            public GcmPubSub get(Object ... in) {
                return mockPubSub;
            }
        };
        UnitTestUtils.setPrivateField(registrar, "gcmPubProvider", gcmPubSubProvider);
        registrar.register((Context)super.getActivity(), (Callback)callback);
        if (!latch.await(60L, TimeUnit.SECONDS)) {
            try {
                this.writeLogcatLogs();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
            Assert.fail((String)"Latch wasn't called");
        }
        if (callback.exception != null) {
            Log.e((String)TAG, (String)callback.exception.getMessage(), (Throwable)callback.exception);
            Assert.fail((String)callback.exception.getMessage());
        }
        ArgumentCaptor postCaptore = ArgumentCaptor.forClass(String.class);
        ((HttpProvider)Mockito.verify((Object)provider.mock)).post((String)postCaptore.capture());
        JSONObject object = new JSONObject((String)postCaptore.getValue());
        Assert.assertEquals((Object)UnitTestUtils.getPrivateField(registrar, "deviceToken"), (Object)object.getString("deviceToken"));
        String jsonData = new GCMSharedPreferenceProvider().get(new Object[]{this.getActivity()}).getString(TEST_REGISTRAR_PREFERENCES_KEY, TAG);
        Assert.assertNotNull((Object)jsonData);
        Assert.assertEquals((Object)UnitTestUtils.getPrivateField(registrar, "deviceToken"), (Object)new JSONObject(jsonData).getString("deviceToken"));
        Assert.assertEquals((long)new JSONArray((Object)CATEGORIES).length(), (long)new JSONObject(jsonData).getJSONArray("categories").length());
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).subscribe("tempId", "/topics/test", null);
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).subscribe("tempId", "/topics/anotherTest", null);
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).subscribe("tempId", "/topics/Variant", null);
    }

    @Test
    public void testUnregister() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setCategories(CATEGORIES).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        final GcmPubSub mockPubSub = (GcmPubSub)Mockito.mock(GcmPubSub.class);
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).unsubscribe(Matchers.anyString(), Matchers.anyString());
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).subscribe(Matchers.anyString(), Matchers.anyString(), (Bundle)Matchers.any(Bundle.class));
        Provider<GcmPubSub> gcmPubSubProvider = new Provider<GcmPubSub>(){

            public GcmPubSub get(Object ... in) {
                return mockPubSub;
            }
        };
        UnitTestUtils.setPrivateField(registrar, "gcmPubProvider", gcmPubSubProvider);
        VoidCallback callback = new VoidCallback(latch);
        AeroGearGCMPushRegistrar spy = (AeroGearGCMPushRegistrar)Mockito.spy((Object)registrar);
        spy.register((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        if (callback.exception != null) {
            Log.e((String)TAG, (String)callback.exception.getMessage(), (Throwable)callback.exception);
            Assert.fail((String)callback.exception.getMessage());
        }
        ((InstanceID)Mockito.verify((Object)instanceIdProvider.mock)).deleteToken(Matchers.anyString(), Matchers.anyString());
        ((HttpProvider)Mockito.verify((Object)provider.mock)).delete(Mockito.matches((String)"tempId"));
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).unsubscribe("tempId", "/topics/test");
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).unsubscribe("tempId", "/topics/anotherTest");
        ((GcmPubSub)Mockito.verify((Object)mockPubSub, (VerificationMode)Mockito.times((int)1))).unsubscribe("tempId", "/topics/Variant");
        Assert.assertNull((Object)callback.exception);
        Assert.assertEquals((Object)"", (Object)UnitTestUtils.getPrivateField(registrar, "deviceToken"));
    }

    @Test
    public void testRegisterExceptionsAreCaught() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        VoidCallback callback = new VoidCallback(latch);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        registrar.register((Context)this.getActivity(), (Callback)callback);
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)callback.exception);
        Assert.assertFalse((boolean)(callback.exception instanceof IOException));
    }

    @Test
    public void testUnregisterExceptionsAreCaught() throws Exception {
        UnifiedPushConfig config = new UnifiedPushConfig().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = new AeroGearGCMPushRegistrar(config);
        CountDownLatch latch = new CountDownLatch(1);
        VoidCallback callback = new VoidCallback(latch);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        registrar.unregister((Context)this.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)callback.exception);
        Assert.assertFalse((boolean)(callback.exception instanceof IOException));
    }

    @Test
    public void testUnregisterTwice() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        StubHttpProvider provider = new StubHttpProvider();
        final GcmPubSub mockPubSub = (GcmPubSub)Mockito.mock(GcmPubSub.class);
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).unsubscribe(Matchers.anyString(), Matchers.anyString());
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).subscribe(Matchers.anyString(), Matchers.anyString(), (Bundle)Matchers.any(Bundle.class));
        Provider<GcmPubSub> gcmPubSubProvider = new Provider<GcmPubSub>(){

            public GcmPubSub get(Object ... in) {
                return mockPubSub;
            }
        };
        UnitTestUtils.setPrivateField(registrar, "gcmPubProvider", gcmPubSubProvider);
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        VoidCallback callback = new VoidCallback(latch);
        AeroGearGCMPushRegistrar spy = (AeroGearGCMPushRegistrar)Mockito.spy((Object)registrar);
        spy.register((Context)super.getActivity(), (Callback)callback);
        latch.await(1L, TimeUnit.SECONDS);
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(4L, TimeUnit.SECONDS);
        Assert.assertNull((Object)callback.exception);
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        spy.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(4L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)callback.exception);
        Assert.assertTrue((boolean)(callback.exception instanceof IllegalStateException));
    }

    @Test
    public void testRegistrationTokensAreNotCached() throws Exception {
        AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearGCMPushRegistrar registrar = (AeroGearGCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        final GcmPubSub mockPubSub = (GcmPubSub)Mockito.mock(GcmPubSub.class);
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).unsubscribe(Matchers.anyString(), Matchers.anyString());
        ((GcmPubSub)Mockito.doNothing().when((Object)mockPubSub)).subscribe(Matchers.anyString(), Matchers.anyString(), (Bundle)Matchers.any(Bundle.class));
        Provider<GcmPubSub> gcmPubSubProvider = new Provider<GcmPubSub>(){

            public GcmPubSub get(Object ... in) {
                return mockPubSub;
            }
        };
        UnitTestUtils.setPrivateField(registrar, "gcmPubProvider", gcmPubSubProvider);
        StubHttpProvider provider = new StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        StubInstanceIDProvider instanceIdProvider = new StubInstanceIDProvider();
        UnitTestUtils.setPrivateField(registrar, "instanceIdProvider", instanceIdProvider);
        UnitTestUtils.setPrivateField(registrar, "preferenceProvider", new Provider<SharedPreferences>(){

            public SharedPreferences get(Object ... in) {
                return new GCMSharedPreferenceProvider().get(new Object[]{AeroGearGCMPushRegistrarTest.this.getActivity()});
            }
        });
        VoidCallback callback = new VoidCallback(latch);
        registrar.register((Context)super.getActivity(), (Callback)callback);
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)new GCMSharedPreferenceProvider().get(new Object[]{this.getActivity()}).getString(TEST_REGISTRAR_PREFERENCES_KEY, null));
        latch = new CountDownLatch(1);
        callback = new VoidCallback(latch);
        registrar.unregister((Context)super.getActivity(), (Callback)callback);
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertNull((Object)callback.exception);
        Assert.assertNull((Object)new GCMSharedPreferenceProvider().get(new Object[]{this.getActivity()}).getString(TEST_REGISTRAR_PREFERENCES_KEY, null));
        ((InstanceID)Mockito.verify((Object)instanceIdProvider.mock, (VerificationMode)Mockito.times((int)1))).deleteToken((String)Mockito.eq((Object)TEST_SENDER_ID), (String)Mockito.eq((Object)"GCM"));
    }

    @Test
    public void testAeroGearGCMPushConfigurationWithoutVariantID() throws Exception {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration();
            config.setSenderId(TEST_SENDER_ID).setPushServerURI(new URI("https://testuri")).setSenderId(TEST_SENDER_ID).setSecret(TEST_SENDER_ID).asRegistrar();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"VariantID can't be null", (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testAeroGearGCMPushConfigurationWithoutSecret() throws Exception {
        try {
            AeroGearGCMPushConfiguration config = new AeroGearGCMPushConfiguration();
            config.setSenderId(TEST_SENDER_ID).setPushServerURI(new URI("https://testuri")).setVariantID(TEST_SENDER_VARIANT).asRegistrar();
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"Secret can't be null", (Object)ex.getMessage());
            return;
        }
        Assert.fail();
    }

    private void writeLogcatLogs() throws IOException {
        Process process = Runtime.getRuntime().exec("logcat -d");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder log = new StringBuilder();
        String line = "";
        while ((line = bufferedReader.readLine()) != null) {
            log.append(line);
        }
        Log.e((String)TAG, (String)log.toString());
    }

    static class StubInstanceIDProvider
    implements Provider<InstanceID> {
        protected final InstanceID mock = (InstanceID)Mockito.mock(InstanceID.class);
        private static final String TEMP_ID = "tempId";

        public StubInstanceIDProvider() {
            try {
                Mockito.when((Object)this.mock.getToken(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)TEMP_ID);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public InstanceID get(Object ... in) {
            return this.mock;
        }
    }

    static class StubHttpProvider
    implements Provider<HttpProvider> {
        protected final HttpProvider mock = (HttpProvider)Mockito.mock(HttpProvider.class);

        public StubHttpProvider() {
            byte[] bytes = new byte[]{1};
            ((HttpProvider)Mockito.doReturn((Object)new HeaderAndBody(bytes, new HashMap())).when((Object)this.mock)).post((String)Mockito.any());
            ((HttpProvider)Mockito.doReturn((Object)new HeaderAndBody(bytes, new HashMap())).when((Object)this.mock)).delete((String)Mockito.any());
        }

        public HttpProvider get(Object ... in) {
            return this.mock;
        }
    }
}

