/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.sync;

import android.app.IntentService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jboss.aerogear.android.sync.SyncServerConnectionListener;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.client.ClientDataStore;
import org.jboss.aerogear.sync.client.ClientInMemoryDataStore;
import org.jboss.aerogear.sync.client.ClientSyncEngine;
import org.jboss.aerogear.sync.client.ClientSynchronizer;
import org.jboss.aerogear.sync.client.DefaultPatchObservable;
import org.jboss.aerogear.sync.client.PatchObservable;
import org.jboss.aerogear.sync.client.SyncClient;
import org.jboss.aerogear.sync.client.netty.NettySyncClient;
import org.jboss.aerogear.sync.jsonpatch.JsonPatchEdit;
import org.jboss.aerogear.sync.jsonpatch.client.JsonPatchClientSynchronizer;

public class SyncService
extends IntentService {
    public static final String SERVER_HOST = "serverHost";
    public static final String SERVER_PORT = "serverPort";
    public static final String SERVER_PATH = "serverPath";
    private static final String TAG = SyncService.class.getSimpleName();
    public static final String MESSAGE_INTENT = "SyncClient.messageIntent";
    private final List<SyncServerConnectionListener> connectionListeners = new ArrayList<SyncServerConnectionListener>();
    private SyncClient<JsonNode, JsonPatchEdit> syncClient;
    private final String clientId = UUID.randomUUID().toString();

    public void addDocument(ClientDocument<JsonNode> clientDocument) {
        this.syncClient.addDocument(clientDocument);
    }

    public void diffAndSend(ClientDocument<JsonNode> clientDocument) {
        this.syncClient.diffAndSend(clientDocument);
    }

    public void subscribe(SyncServerConnectionListener<JsonNode> observer) {
        this.syncClient.addPatchListener(observer);
        this.addConnectionListener(observer);
    }

    public void unsubscribe(SyncServerConnectionListener<JsonNode> observer) {
        this.syncClient.deletePatchListener(observer);
        this.removeConnectionListener(observer);
    }

    public SyncService() {
        super(SyncService.class.getName());
    }

    public IBinder onBind(Intent intent) {
        if (!this.syncClient.isConnected()) {
            this.connectAsync();
        }
        return new SyncServiceBinder(this);
    }

    protected void onHandleIntent(Intent serviceIntent) {
    }

    public void onCreate() {
        try {
            super.onCreate();
            ComponentName myService = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
            Bundle data = this.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            if (data.getString(SERVER_HOST) == null) {
                throw new IllegalStateException("serverHost may not be null");
            }
            if (data.getString(SERVER_PATH) == null) {
                throw new IllegalStateException("serverPath may not be null");
            }
            if (data.getInt(SERVER_PORT, -1) == -1) {
                throw new IllegalStateException("serverPort may not be null");
            }
            JsonPatchClientSynchronizer synchronizer = new JsonPatchClientSynchronizer();
            ClientInMemoryDataStore dataStore = new ClientInMemoryDataStore();
            ClientSyncEngine clientSyncEngine = new ClientSyncEngine((ClientSynchronizer)synchronizer, (ClientDataStore)dataStore, (PatchObservable)new DefaultPatchObservable());
            this.syncClient = NettySyncClient.forHost((String)data.getString(SERVER_HOST)).port(data.getInt(SERVER_PORT)).path(data.getString(SERVER_PATH)).syncEngine(clientSyncEngine).build();
            Log.i((String)SyncService.class.getName(), (String)"onCreated");
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        this.connectAsync();
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.i((String)SyncService.class.getName(), (String)"onDestroy");
    }

    public String getClientId() {
        return this.clientId;
    }

    private void addConnectionListener(SyncServerConnectionListener observer) {
        this.connectionListeners.add(observer);
    }

    private void removeConnectionListener(SyncServerConnectionListener observer) {
        this.connectionListeners.remove(observer);
    }

    private void connectAsync() {
        AsyncTask<Void, Void, Void> task = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    SyncService.this.syncClient.connect();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
                return null;
            }

            protected void onPostExecute(Void result) {
                super.onPostExecute((Object)result);
                for (SyncServerConnectionListener listener : SyncService.this.connectionListeners) {
                    listener.onConnected();
                }
            }
        };
        task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[]{null});
    }

    public static final class SyncServiceBinder
    extends Binder {
        private final SyncService service;

        private SyncServiceBinder(SyncService service) {
            this.service = service;
        }

        public SyncService getService() {
            return this.service;
        }
    }
}

