/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.aerogear.android.impl.pipeline.PipeConfig;
import org.jboss.aerogear.android.impl.pipeline.PipeTypes;
import org.jboss.aerogear.android.impl.pipeline.RestAdapter;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeFactory;

public final class DefaultPipeFactory
implements PipeFactory {
    @Override
    public <T> Pipe<T> createPipe(Class<T> klass, PipeConfig config) {
        if (!PipeTypes.REST.equals(config.getType())) {
            throw new IllegalArgumentException("Type is not supported yet");
        }
        URL url = DefaultPipeFactory.appendEndpoint(config.getBaseURL(), config.getEndpoint());
        RestAdapter<T> createdPipe = new RestAdapter<T>(klass, url, config);
        return createdPipe;
    }

    private static URL appendEndpoint(URL baseURL, String endpoint) {
        try {
            if (!baseURL.toString().endsWith("/")) {
                endpoint = "/" + endpoint;
            }
            return new URL(baseURL + endpoint);
        }
        catch (MalformedURLException e) {
            Log.e((String)"AeroGear", (String)e.getMessage());
            return null;
        }
    }
}

