/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline.paging;

import com.google.common.collect.ForwardingList;
import java.util.List;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.paging.PagedList;

public class WrappingPagedList<T>
extends ForwardingList<T>
implements PagedList<T> {
    private final Pipe<T> pipe;
    private final List<T> data;
    private final ReadFilter nextFilter;
    private final ReadFilter previousFilter;

    public WrappingPagedList(Pipe<T> pipe, List<T> data, ReadFilter nextFilter, ReadFilter previousFilter) {
        this.pipe = pipe;
        this.data = data;
        this.nextFilter = nextFilter;
        this.previousFilter = previousFilter;
    }

    protected List<T> delegate() {
        return this.data;
    }

    @Override
    public void next(Callback<List<T>> callback) {
        this.pipe.readWithFilter(this.nextFilter, callback);
    }

    @Override
    public void previous(Callback<List<T>> callback) {
        this.pipe.readWithFilter(this.previousFilter, callback);
    }

    public ReadFilter getNextFilter() {
        return this.nextFilter;
    }

    public ReadFilter getPreviousFilter() {
        return this.previousFilter;
    }
}

