/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import com.xtremelabs.robolectric.bytecode.RobolectricInternals;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.HttpRedirect;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.RoutedRequest;
import org.apache.http.impl.client.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultRequestDirector
implements RequestDirector {
    private final Log log;
    protected final ClientConnectionManager connManager;
    protected final HttpRoutePlanner routePlanner;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final ConnectionKeepAliveStrategy keepAliveStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    protected final RedirectHandler redirectHandler;
    protected final AuthenticationHandler targetAuthHandler;
    protected final AuthenticationHandler proxyAuthHandler;
    protected final UserTokenHandler userTokenHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    protected final AuthState targetAuthState;
    protected final AuthState proxyAuthState;
    private int redirectCount;
    private int maxRedirects;
    private HttpHost virtualHost;
    public Object __shadow__;

    DefaultRequestDirector(Log log, HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"<init>", (Object)this, (String[])new String[]{"org.apache.commons.logging.Log", "org.apache.http.protocol.HttpRequestExecutor", "org.apache.http.conn.ClientConnectionManager", "org.apache.http.ConnectionReuseStrategy", "org.apache.http.conn.ConnectionKeepAliveStrategy", "org.apache.http.conn.routing.HttpRoutePlanner", "org.apache.http.protocol.HttpProcessor", "org.apache.http.client.HttpRequestRetryHandler", "org.apache.http.client.RedirectHandler", "org.apache.http.client.AuthenticationHandler", "org.apache.http.client.AuthenticationHandler", "org.apache.http.client.UserTokenHandler", "org.apache.http.params.HttpParams"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)log), RobolectricInternals.autobox((Object)httpRequestExecutor), RobolectricInternals.autobox((Object)clientConnectionManager), RobolectricInternals.autobox((Object)connectionReuseStrategy), RobolectricInternals.autobox((Object)connectionKeepAliveStrategy), RobolectricInternals.autobox((Object)httpRoutePlanner), RobolectricInternals.autobox((Object)httpProcessor), RobolectricInternals.autobox((Object)httpRequestRetryHandler), RobolectricInternals.autobox((Object)redirectHandler), RobolectricInternals.autobox((Object)authenticationHandler), RobolectricInternals.autobox((Object)authenticationHandler2), RobolectricInternals.autobox((Object)userTokenHandler), RobolectricInternals.autobox((Object)httpParams)});
            }
        }
        finally {
            Object var15_16 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public DefaultRequestDirector(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"<init>", (Object)this, (String[])new String[]{"org.apache.http.protocol.HttpRequestExecutor", "org.apache.http.conn.ClientConnectionManager", "org.apache.http.ConnectionReuseStrategy", "org.apache.http.conn.ConnectionKeepAliveStrategy", "org.apache.http.conn.routing.HttpRoutePlanner", "org.apache.http.protocol.HttpProcessor", "org.apache.http.client.HttpRequestRetryHandler", "org.apache.http.client.RedirectHandler", "org.apache.http.client.AuthenticationHandler", "org.apache.http.client.AuthenticationHandler", "org.apache.http.client.UserTokenHandler", "org.apache.http.params.HttpParams"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)httpRequestExecutor), RobolectricInternals.autobox((Object)clientConnectionManager), RobolectricInternals.autobox((Object)connectionReuseStrategy), RobolectricInternals.autobox((Object)connectionKeepAliveStrategy), RobolectricInternals.autobox((Object)httpRoutePlanner), RobolectricInternals.autobox((Object)httpProcessor), RobolectricInternals.autobox((Object)httpRequestRetryHandler), RobolectricInternals.autobox((Object)redirectHandler), RobolectricInternals.autobox((Object)authenticationHandler), RobolectricInternals.autobox((Object)authenticationHandler2), RobolectricInternals.autobox((Object)userTokenHandler), RobolectricInternals.autobox((Object)httpParams)});
            }
        }
        finally {
            Object var14_15 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private RequestWrapper wrapRequest(HttpRequest request) throws ProtocolException {
        Object object;
        try {
            Object object2;
            object = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"wrapRequest", (Object)this, (String[])new String[]{"org.apache.http.HttpRequest"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)request)})) != null ? (RequestWrapper)object2 : null) : (request instanceof HttpEntityEnclosingRequest ? new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request) : new RequestWrapper(request));
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        EntityEnclosingRequestWrapper entityEnclosingRequestWrapper = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return entityEnclosingRequestWrapper;
    }

    protected void rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        block10: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"rewriteRequestURI", (Object)this, (String[])new String[]{"org.apache.http.impl.client.RequestWrapper", "org.apache.http.conn.routing.HttpRoute"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)request), RobolectricInternals.autobox((Object)route)});
                    break block10;
                }
                try {
                    URI uri = request.getURI();
                    if (route.getProxyHost() != null && !route.isTunnelled()) {
                        if (!uri.isAbsolute()) {
                            HttpHost target = route.getTargetHost();
                            uri = URIUtils.rewriteURI((URI)uri, (HttpHost)target);
                            request.setURI(uri);
                        }
                    } else if (uri.isAbsolute()) {
                        uri = URIUtils.rewriteURI((URI)uri, null);
                        request.setURI(uri);
                    }
                }
                catch (URISyntaxException ex) {
                    throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
                }
            }
            finally {
                Object var6_8 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
            }
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpResponse httpResponse;
        block45: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"execute", (Object)this, (String[])new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)target), RobolectricInternals.autobox((Object)request), RobolectricInternals.autobox((Object)context)});
                    httpResponse = object != null ? (HttpResponse)object : null;
                    break block45;
                }
                HttpRequest orig = request;
                RequestWrapper origWrapper = this.wrapRequest(orig);
                origWrapper.setParams(this.params);
                HttpRoute origRoute = this.determineRoute(target, (HttpRequest)origWrapper, context);
                this.virtualHost = (HttpHost)orig.getParams().getParameter("http.virtual-host");
                RoutedRequest roureq = new RoutedRequest(origWrapper, origRoute);
                long timeout = ConnManagerParams.getTimeout((HttpParams)this.params);
                int execCount = 0;
                boolean reuse = false;
                boolean done = false;
                try {
                    HttpResponse response = null;
                    while (!done) {
                        RoutedRequest followup;
                        RequestWrapper wrapper = roureq.getRequest();
                        HttpRoute route = roureq.getRoute();
                        response = null;
                        Object userToken = context.getAttribute("http.user-token");
                        if (this.managedConn == null) {
                            ClientConnectionRequest connRequest = this.connManager.requestConnection(route, userToken);
                            if (orig instanceof AbortableHttpRequest) {
                                ((AbortableHttpRequest)orig).setConnectionRequest(connRequest);
                            }
                            try {
                                this.managedConn = connRequest.getConnection(timeout, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException interrupted) {
                                InterruptedIOException iox = new InterruptedIOException();
                                iox.initCause(interrupted);
                                throw iox;
                            }
                            if (HttpConnectionParams.isStaleCheckingEnabled((HttpParams)this.params) && this.managedConn.isOpen()) {
                                this.log.debug((Object)"Stale connection check");
                                if (this.managedConn.isStale()) {
                                    this.log.debug((Object)"Stale connection detected");
                                    this.managedConn.close();
                                }
                            }
                        }
                        if (orig instanceof AbortableHttpRequest) {
                            ((AbortableHttpRequest)orig).setReleaseTrigger((ConnectionReleaseTrigger)this.managedConn);
                        }
                        if (!this.managedConn.isOpen()) {
                            this.managedConn.open(route, context, this.params);
                        } else {
                            this.managedConn.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
                        }
                        try {
                            this.establishRoute(route, context);
                        }
                        catch (TunnelRefusedException ex) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)ex.getMessage());
                            }
                            response = ex.getResponse();
                            break;
                        }
                        wrapper.resetHeaders();
                        this.rewriteRequestURI(wrapper, route);
                        target = this.virtualHost;
                        if (target == null) {
                            target = route.getTargetHost();
                        }
                        HttpHost proxy = route.getProxyHost();
                        context.setAttribute("http.target_host", (Object)target);
                        context.setAttribute("http.proxy_host", (Object)proxy);
                        context.setAttribute("http.connection", (Object)this.managedConn);
                        context.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
                        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
                        this.requestExec.preProcess((HttpRequest)wrapper, this.httpProcessor, context);
                        boolean retrying = true;
                        IOException retryReason = null;
                        while (retrying) {
                            ++execCount;
                            wrapper.incrementExecCount();
                            if (wrapper.getExecCount() > 1 && !wrapper.isRepeatable()) {
                                this.log.debug((Object)"Cannot retry non-repeatable request");
                                if (retryReason != null) {
                                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.  The cause lists the reason the original request failed.", retryReason);
                                }
                                throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                            }
                            try {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Attempt " + execCount + " to execute request"));
                                }
                                response = this.requestExec.execute((HttpRequest)wrapper, (HttpClientConnection)this.managedConn, context);
                                retrying = false;
                            }
                            catch (IOException ex) {
                                this.log.debug((Object)"Closing the connection.");
                                this.managedConn.close();
                                if (this.retryHandler.retryRequest(ex, execCount, context)) {
                                    if (this.log.isInfoEnabled()) {
                                        this.log.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage()));
                                    }
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                                    }
                                } else {
                                    throw ex;
                                }
                                this.log.info((Object)"Retrying request");
                                retryReason = ex;
                                if (!route.isTunnelled()) {
                                    this.log.debug((Object)"Reopening the direct connection.");
                                    this.managedConn.open(route, context, this.params);
                                    continue;
                                }
                                this.log.debug((Object)"Proxied connection. Need to start over.");
                                retrying = false;
                            }
                        }
                        if (response == null) continue;
                        response.setParams(this.params);
                        this.requestExec.postProcess(response, this.httpProcessor, context);
                        reuse = this.reuseStrategy.keepAlive(response, context);
                        if (reuse) {
                            long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                            this.managedConn.setIdleDuration(duration, TimeUnit.MILLISECONDS);
                            if (this.log.isDebugEnabled()) {
                                if (duration >= 0L) {
                                    this.log.debug((Object)("Connection can be kept alive for " + duration + " ms"));
                                } else {
                                    this.log.debug((Object)"Connection can be kept alive indefinitely");
                                }
                            }
                        }
                        if ((followup = this.handleResponse(roureq, response, context)) == null) {
                            done = true;
                        } else {
                            if (reuse) {
                                HttpEntity entity = response.getEntity();
                                if (entity != null) {
                                    entity.consumeContent();
                                }
                                this.managedConn.markReusable();
                            } else {
                                this.managedConn.close();
                            }
                            if (!followup.getRoute().equals((Object)roureq.getRoute())) {
                                this.releaseConnection();
                            }
                            roureq = followup;
                        }
                        if (this.managedConn == null || userToken != null) continue;
                        userToken = this.userTokenHandler.getUserToken(context);
                        context.setAttribute("http.user-token", userToken);
                        if (userToken == null) continue;
                        this.managedConn.setState(userToken);
                    }
                    if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) {
                        if (reuse) {
                            this.managedConn.markReusable();
                        }
                        this.releaseConnection();
                    } else {
                        HttpEntity entity = response.getEntity();
                        entity = new BasicManagedEntity(entity, this.managedConn, reuse);
                        response.setEntity(entity);
                    }
                    httpResponse = response;
                }
                catch (HttpException ex) {
                    this.abortConnection();
                    throw ex;
                }
                catch (IOException ex) {
                    this.abortConnection();
                    throw ex;
                }
                catch (RuntimeException ex) {
                    this.abortConnection();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var23_29 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        HttpResponse httpResponse2 = httpResponse;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return httpResponse2;
    }

    protected void releaseConnection() {
        block6: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"releaseConnection", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                    break block6;
                }
                try {
                    this.managedConn.releaseConnection();
                }
                catch (IOException ignored) {
                    this.log.debug((Object)"IOException releasing connection", (Throwable)ignored);
                }
                this.managedConn = null;
            }
            finally {
                Object var3_4 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
            }
        }
    }

    protected HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        Object object;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object2 = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"determineRoute", (Object)this, (String[])new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)target), RobolectricInternals.autobox((Object)request), RobolectricInternals.autobox((Object)context)});
                object = object2 != null ? (HttpRoute)object2 : null;
            } else {
                if (target == null) {
                    target = (HttpHost)request.getParams().getParameter("http.default-host");
                }
                if (target == null) {
                    throw new IllegalStateException("Target host must not be null, or set in parameters.");
                }
                object = this.routePlanner.determineRoute(target, request, context);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        HttpRoute httpRoute = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return httpRoute;
    }

    protected void establishRoute(HttpRoute route, HttpContext context) throws HttpException, IOException {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"establishRoute", (Object)this, (String[])new String[]{"org.apache.http.conn.routing.HttpRoute", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)route), RobolectricInternals.autobox((Object)context)});
            } else {
                int step;
                BasicRouteDirector rowdy = new BasicRouteDirector();
                do {
                    HttpRoute fact = this.managedConn.getRoute();
                    step = rowdy.nextStep((RouteInfo)route, (RouteInfo)fact);
                    switch (step) {
                        case 1: 
                        case 2: {
                            this.managedConn.open(route, context, this.params);
                            break;
                        }
                        case 3: {
                            boolean secure = this.createTunnelToTarget(route, context);
                            this.log.debug((Object)"Tunnel to target created.");
                            this.managedConn.tunnelTarget(secure, this.params);
                            break;
                        }
                        case 4: {
                            int hop = fact.getHopCount() - 1;
                            boolean secure = this.createTunnelToProxy(route, hop, context);
                            this.log.debug((Object)"Tunnel to proxy created.");
                            this.managedConn.tunnelProxy(route.getHopTarget(hop), secure, this.params);
                            break;
                        }
                        case 5: {
                            this.managedConn.layerProtocol(context, this.params);
                            break;
                        }
                        case -1: {
                            throw new IllegalStateException("Unable to establish route.\nplanned = " + route + "\ncurrent = " + fact);
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                        }
                    }
                } while (step > 0);
            }
        }
        finally {
            Object var9_10 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    protected boolean createTunnelToTarget(HttpRoute route, HttpContext context) throws HttpException, IOException {
        boolean bl;
        block12: {
            try {
                int status;
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"createTunnelToTarget", (Object)this, (String[])new String[]{"org.apache.http.conn.routing.HttpRoute", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)route), RobolectricInternals.autobox((Object)context)});
                    bl = object != null ? (Boolean)object : false;
                    break block12;
                }
                HttpHost proxy = route.getProxyHost();
                HttpHost target = route.getTargetHost();
                HttpResponse response = null;
                boolean done = false;
                while (!done) {
                    done = true;
                    if (!this.managedConn.isOpen()) {
                        this.managedConn.open(route, context, this.params);
                    }
                    HttpRequest connect = this.createConnectRequest(route, context);
                    connect.setParams(this.params);
                    context.setAttribute("http.target_host", (Object)target);
                    context.setAttribute("http.proxy_host", (Object)proxy);
                    context.setAttribute("http.connection", (Object)this.managedConn);
                    context.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
                    context.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
                    context.setAttribute("http.request", (Object)connect);
                    this.requestExec.preProcess(connect, this.httpProcessor, context);
                    response = this.requestExec.execute(connect, (HttpClientConnection)this.managedConn, context);
                    response.setParams(this.params);
                    this.requestExec.postProcess(response, this.httpProcessor, context);
                    int status2 = response.getStatusLine().getStatusCode();
                    if (status2 < 200) {
                        throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
                    }
                    CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                    if (credsProvider == null || !HttpClientParams.isAuthenticating((HttpParams)this.params)) continue;
                    if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                        block13: {
                            this.log.debug((Object)"Proxy requested authentication");
                            Map challenges = this.proxyAuthHandler.getChallenges(response, context);
                            try {
                                this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) break block13;
                                this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                                break;
                            }
                        }
                        this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                        if (this.proxyAuthState.getCredentials() == null) continue;
                        done = false;
                        if (this.reuseStrategy.keepAlive(response, context)) {
                            this.log.debug((Object)"Connection kept alive");
                            HttpEntity entity = response.getEntity();
                            if (entity == null) continue;
                            entity.consumeContent();
                            continue;
                        }
                        this.managedConn.close();
                        continue;
                    }
                    this.proxyAuthState.setAuthScope(null);
                }
                if ((status = response.getStatusLine().getStatusCode()) > 299) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
                    }
                    this.managedConn.close();
                    throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
                }
                this.managedConn.markReusable();
                bl = false;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    protected boolean createTunnelToProxy(HttpRoute route, int hop, HttpContext context) throws HttpException, IOException {
        boolean bl;
        block3: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"createTunnelToProxy", (Object)this, (String[])new String[]{"org.apache.http.conn.routing.HttpRoute", "int", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)route), RobolectricInternals.autobox((int)hop), RobolectricInternals.autobox((Object)context)});
                    bl = object != null ? (Boolean)object : false;
                    break block3;
                }
                throw new UnsupportedOperationException("Proxy chains are not supported.");
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    protected HttpRequest createConnectRequest(HttpRoute route, HttpContext context) {
        HttpRequest httpRequest;
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                Object object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"createConnectRequest", (Object)this, (String[])new String[]{"org.apache.http.conn.routing.HttpRoute", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)route), RobolectricInternals.autobox((Object)context)});
                httpRequest = object != null ? (HttpRequest)object : null;
            } else {
                HttpHost target = route.getTargetHost();
                String host = target.getHostName();
                int port = target.getPort();
                if (port < 0) {
                    Scheme scheme = this.connManager.getSchemeRegistry().getScheme(target.getSchemeName());
                    port = scheme.getDefaultPort();
                }
                StringBuilder buffer = new StringBuilder(host.length() + 6);
                buffer.append(host);
                buffer.append(':');
                buffer.append(Integer.toString(port));
                String authority = buffer.toString();
                ProtocolVersion ver = HttpProtocolParams.getVersion((HttpParams)this.params);
                BasicHttpRequest req = new BasicHttpRequest("CONNECT", authority, ver);
                httpRequest = req;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        HttpRequest httpRequest2 = httpRequest;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return httpRequest2;
    }

    protected RoutedRequest handleResponse(RoutedRequest roureq, HttpResponse response, HttpContext context) throws HttpException, IOException {
        Object object;
        block16: {
            try {
                if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                    Object object2 = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"handleResponse", (Object)this, (String[])new String[]{"org.apache.http.impl.client.RoutedRequest", "org.apache.http.HttpResponse", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)roureq), RobolectricInternals.autobox((Object)response), RobolectricInternals.autobox((Object)context)});
                    object = object2 != null ? (RoutedRequest)object2 : null;
                    break block16;
                }
                HttpRoute route = roureq.getRoute();
                RequestWrapper request = roureq.getRequest();
                HttpParams params = request.getParams();
                if (HttpClientParams.isRedirecting((HttpParams)params) && this.redirectHandler.isRedirectRequested(response, context)) {
                    if (this.redirectCount >= this.maxRedirects) {
                        throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
                    }
                    ++this.redirectCount;
                    this.virtualHost = null;
                    URI uri = this.redirectHandler.getLocationURI(response, context);
                    HttpHost newTarget = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    this.targetAuthState.setAuthScope(null);
                    this.proxyAuthState.setAuthScope(null);
                    if (!route.getTargetHost().equals((Object)newTarget)) {
                        this.targetAuthState.invalidate();
                        AuthScheme authScheme = this.proxyAuthState.getAuthScheme();
                        if (authScheme != null && authScheme.isConnectionBased()) {
                            this.proxyAuthState.invalidate();
                        }
                    }
                    HttpRedirect redirect = new HttpRedirect(request.getMethod(), uri);
                    HttpRequest orig = request.getOriginal();
                    redirect.setHeaders(orig.getAllHeaders());
                    RequestWrapper wrapper = new RequestWrapper((HttpRequest)redirect);
                    wrapper.setParams(params);
                    HttpRoute newRoute = this.determineRoute(newTarget, (HttpRequest)wrapper, context);
                    RoutedRequest newRequest = new RoutedRequest(wrapper, newRoute);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Redirecting to '" + uri + "' via " + newRoute));
                    }
                    object = newRequest;
                    break block16;
                }
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                if (credsProvider != null && HttpClientParams.isAuthenticating((HttpParams)params)) {
                    Map challenges;
                    if (this.targetAuthHandler.isAuthenticationRequested(response, context)) {
                        HttpHost target;
                        block17: {
                            target = (HttpHost)context.getAttribute("http.target_host");
                            if (target == null) {
                                target = route.getTargetHost();
                            }
                            this.log.debug((Object)"Target requested authentication");
                            challenges = this.targetAuthHandler.getChallenges(response, context);
                            try {
                                this.processChallenges(challenges, this.targetAuthState, this.targetAuthHandler, response, context);
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) break block17;
                                this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                                object = null;
                                break block16;
                            }
                        }
                        this.updateAuthState(this.targetAuthState, target, credsProvider);
                        object = this.targetAuthState.getCredentials() != null ? roureq : null;
                        break block16;
                    }
                    this.targetAuthState.setAuthScope(null);
                    if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                        HttpHost proxy;
                        block18: {
                            proxy = route.getProxyHost();
                            this.log.debug((Object)"Proxy requested authentication");
                            challenges = this.proxyAuthHandler.getChallenges(response, context);
                            try {
                                this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) break block18;
                                this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                                object = null;
                                break block16;
                            }
                        }
                        this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                        object = this.proxyAuthState.getCredentials() != null ? roureq : null;
                        break block16;
                    }
                    this.proxyAuthState.setAuthScope(null);
                }
                object = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
                throw throwable;
            }
        }
        RoutedRequest routedRequest = object;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return routedRequest;
    }

    private void abortConnection() {
        block8: {
            try {
                ManagedClientConnection mcc;
                block9: {
                    if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                        RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"abortConnection", (Object)this, (String[])new String[0], (Object[])new Object[0]);
                        break block8;
                    }
                    mcc = this.managedConn;
                    if (mcc == null) break block8;
                    this.managedConn = null;
                    try {
                        mcc.abortConnection();
                    }
                    catch (IOException ex) {
                        if (!this.log.isDebugEnabled()) break block9;
                        this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                try {
                    mcc.releaseConnection();
                }
                catch (IOException ignored) {
                    this.log.debug((Object)"Error releasing connection", (Throwable)ignored);
                }
            }
            finally {
                Object var4_6 = null;
                RobolectricInternals.onMethodInvocationFinish((Object)this);
            }
        }
    }

    private void processChallenges(Map<String, Header> challenges, AuthState authState, AuthenticationHandler authHandler, HttpResponse response, HttpContext context) throws MalformedChallengeException, AuthenticationException {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"processChallenges", (Object)this, (String[])new String[]{"java.util.Map", "org.apache.http.auth.AuthState", "org.apache.http.client.AuthenticationHandler", "org.apache.http.HttpResponse", "org.apache.http.protocol.HttpContext"}, (Object[])new Object[]{RobolectricInternals.autobox(challenges), RobolectricInternals.autobox((Object)authState), RobolectricInternals.autobox((Object)authHandler), RobolectricInternals.autobox((Object)response), RobolectricInternals.autobox((Object)context)});
            } else {
                String id;
                Header challenge;
                AuthScheme authScheme = authState.getAuthScheme();
                if (authScheme == null) {
                    authScheme = authHandler.selectScheme(challenges, response, context);
                    authState.setAuthScheme(authScheme);
                }
                if ((challenge = challenges.get((id = authScheme.getSchemeName()).toLowerCase(Locale.ENGLISH))) == null) {
                    throw new AuthenticationException(id + " authorization challenge expected, but not found");
                }
                authScheme.processChallenge(challenge);
                this.log.debug((Object)"Authorization challenge processed");
            }
        }
        finally {
            Object var10_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    private void updateAuthState(AuthState authState, HttpHost host, CredentialsProvider credsProvider) {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"updateAuthState", (Object)this, (String[])new String[]{"org.apache.http.auth.AuthState", "org.apache.http.HttpHost", "org.apache.http.client.CredentialsProvider"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)authState), RobolectricInternals.autobox((Object)host), RobolectricInternals.autobox((Object)credsProvider)});
            } else if (!authState.isValid()) {
            } else {
                Credentials creds;
                String hostname = host.getHostName();
                int port = host.getPort();
                if (port < 0) {
                    Scheme scheme = this.connManager.getSchemeRegistry().getScheme(host);
                    port = scheme.getDefaultPort();
                }
                AuthScheme authScheme = authState.getAuthScheme();
                AuthScope authScope = new AuthScope(hostname, port, authScheme.getRealm(), authScheme.getSchemeName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication scope: " + authScope));
                }
                if ((creds = authState.getCredentials()) == null) {
                    creds = credsProvider.getCredentials(authScope);
                    if (this.log.isDebugEnabled()) {
                        if (creds != null) {
                            this.log.debug((Object)"Found credentials");
                        } else {
                            this.log.debug((Object)"Credentials not found");
                        }
                    }
                } else if (authScheme.isComplete()) {
                    this.log.debug((Object)"Authentication failed");
                    creds = null;
                }
                authState.setAuthScope(authScope);
                authState.setCredentials(creds);
            }
        }
        finally {
            Object var10_11 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public DefaultRequestDirector() {
        try {
            if (!RobolectricInternals.shouldCallDirectly((Object)this)) {
                RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"<init>", (Object)this, (String[])new String[0], (Object[])new Object[0]);
            }
        }
        finally {
            Object var2_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        try {
            Object object2;
            bl = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object2 = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"equals", (Object)this, (String[])new String[]{"java.lang.Object"}, (Object[])new Object[]{RobolectricInternals.autobox((Object)object)})) != null ? ((Boolean)object2).booleanValue() : super.equals(object)) : super.equals(object);
        }
        catch (Throwable throwable) {
            boolean bl2 = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        boolean bl3 = bl;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return bl3;
    }

    public int hashCode() {
        int n;
        try {
            Object object;
            n = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"hashCode", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? ((Integer)object).intValue() : super.hashCode()) : 0;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        int n2 = n;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return n2;
    }

    public String toString() {
        String string;
        try {
            Object object;
            string = !RobolectricInternals.shouldCallDirectly((Object)this) ? ((object = RobolectricInternals.methodInvoked(DefaultRequestDirector.class, (String)"toString", (Object)this, (String[])new String[0], (Object[])new Object[0])) != null ? (String)object : super.toString()) : super.toString();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            RobolectricInternals.onMethodInvocationFinish((Object)this);
            throw throwable;
        }
        String string2 = string;
        RobolectricInternals.onMethodInvocationFinish((Object)this);
        return string2;
    }
}

