/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.router.error.ErrorRoute;
import org.mvel2.templates.TemplateRuntime;

@WebFilter(filterName="aerogear-error-filter", urlPatterns={"/ErrorFilter"}, dispatcherTypes={DispatcherType.FORWARD})
public class ErrorFilter
implements Filter {
    private static final String TEMPLATE = "/org/jboss/aerogear/controller/router/error.html";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Throwable throwable = (Throwable)request.getAttribute(ErrorRoute.DEFAULT.getExceptionAttrName());
        String html = ErrorFilter.readTemplate(TEMPLATE, throwable);
        response.getWriter().write(html);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTemplate(String templatePath, Throwable throwable) {
        InputStream in = null;
        try {
            in = ErrorFilter.class.getResourceAsStream(templatePath);
            HashMap<String, Throwable> templateParameters = new HashMap<String, Throwable>();
            templateParameters.put("exception", throwable);
            String string = (String)TemplateRuntime.eval((InputStream)in, templateParameters);
            return string;
        }
        finally {
            ErrorFilter.safeClose(in);
        }
    }

    private static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                AeroGearLogger.LOGGER.closeInputStream(e);
            }
        }
    }

    public void destroy() {
    }
}

