/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import com.google.common.base.Optional;

public class PaginationInfo {
    public static final String DEFAULT_OFFSET_PARAM_NAME = "offset";
    public static final String DEFAULT_LIMIT_PARAM_NAME = "limit";
    private final String offsetParamName;
    private final int offset;
    private final String limitParamName;
    private final int limit;
    private final boolean webLinking;
    private final Optional<String> headerPrefix;

    public PaginationInfo(String offsetParamName, int offset, String limitParamName, int limit) {
        this(offsetParamName, offset, limitParamName, limit, true, (Optional<String>)Optional.absent());
    }

    public PaginationInfo(String offsetParamName, int offset, String limitParamName, int limit, String headerPrefix) {
        this(offsetParamName, offset, limitParamName, limit, false, (Optional<String>)Optional.fromNullable((Object)headerPrefix));
    }

    private PaginationInfo(String offsetParamName, int offset, String limitParamName, int limit, boolean webLinking, Optional<String> headerPrefix) {
        this.offsetParamName = offsetParamName;
        this.offset = offset;
        this.limitParamName = limitParamName;
        this.limit = limit;
        this.webLinking = webLinking;
        this.headerPrefix = headerPrefix;
    }

    public String getOffsetParamName() {
        return this.offsetParamName;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getLimitParamName() {
        return this.limitParamName;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean webLinking() {
        return this.webLinking;
    }

    public String toString() {
        return "PaginationInfo[offsetParamName=" + this.offsetParamName + ", offset=" + this.offset + ", limitParamName=" + this.limitParamName + ", limit=" + this.limit + ", webLinking=" + this.webLinking + ", headerPrefix=" + this.headerPrefix + "]";
    }

    public Optional<String> getHeaderPrefix() {
        return this.headerPrefix;
    }

    public static PaginationInfoBuilder offset(int value) {
        return PaginationInfo.offset(DEFAULT_OFFSET_PARAM_NAME, value);
    }

    public static PaginationInfoBuilder offset(String offsetParamName, int value) {
        return new PaginationInfoBuilderImpl().offset(offsetParamName, value);
    }

    public static class PaginationInfoBuilderImpl
    implements PaginationInfoBuilder {
        private String offsetParamName = "offset";
        private String limitParamName = "limit";
        private String headerPrefix;
        private int offset;
        private int limit;
        private boolean webLinking;

        @Override
        public PaginationInfoBuilder offset(String paramName, int value) {
            this.offsetParamName = paramName;
            this.offset = value;
            return this;
        }

        @Override
        public PaginationInfoBuilder limit(String paramName, int value) {
            this.limitParamName = paramName;
            this.limit = value;
            return this;
        }

        @Override
        public PaginationInfoBuilder customHeadersPrefix(String prefix) {
            this.headerPrefix = prefix;
            return this;
        }

        @Override
        public PaginationInfoBuilder customHeaders() {
            this.headerPrefix = "AG-";
            return this;
        }

        @Override
        public PaginationInfoBuilder limit(int value) {
            this.limit = value;
            return this;
        }

        @Override
        public PaginationInfoBuilder webLinking(boolean enabled) {
            this.webLinking = enabled;
            return this;
        }

        @Override
        public PaginationInfo build() {
            if (this.webLinking) {
                return new PaginationInfo(this.offsetParamName, this.offset, this.limitParamName, this.limit);
            }
            return new PaginationInfo(this.offsetParamName, this.offset, this.limitParamName, this.limit, this.headerPrefix);
        }
    }

    public static interface PaginationInfoBuilder {
        public PaginationInfoBuilder offset(String var1, int var2);

        public PaginationInfoBuilder limit(String var1, int var2);

        public PaginationInfoBuilder limit(int var1);

        public PaginationInfoBuilder customHeaders();

        public PaginationInfoBuilder customHeadersPrefix(String var1);

        public PaginationInfoBuilder webLinking(boolean var1);

        public PaginationInfo build();
    }
}

