/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteDescriptor;

public class DefaultRoute
implements Route {
    private final String path;
    private final Class<?> targetClass;
    private final Method targetMethod;
    private final Set<RequestMethod> methods;
    private final Set<String> roles;
    private final Set<String> produces;
    private final Set<Class<? extends Throwable>> throwables;

    public DefaultRoute(RouteDescriptor descriptor) {
        this.path = descriptor.getPath();
        this.methods = this.asSet(descriptor.getMethods());
        this.targetMethod = descriptor.getTargetMethod();
        this.targetClass = descriptor.getTargetClass();
        this.roles = this.asSet((String[])Objects.firstNonNull((Object)descriptor.getRoles(), (Object)new String[0]));
        this.throwables = (Set)Objects.firstNonNull(descriptor.getThrowables(), DefaultRoute.emptyThrowableSet());
        this.produces = this.asSet((String[])Objects.firstNonNull((Object)descriptor.getProduces(), (Object)DefaultRoute.defaultMediaType()));
    }

    @Override
    public Set<RequestMethod> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public boolean matches(RequestMethod method, String path, Set<String> acceptHeaders) {
        return this.methods.contains((Object)method) && this.isPathCompatible(path) && this.matchesProduces(acceptHeaders);
    }

    private boolean matchesProduces(Set<String> acceptHeaders) {
        if (acceptHeaders.isEmpty() || acceptHeaders.contains(MediaType.ANY.toString())) {
            return true;
        }
        return !Sets.intersection(this.produces, acceptHeaders).isEmpty();
    }

    private boolean isPathCompatible(String path) {
        int paramStart;
        if (this.isParameterized() && (paramStart = this.path.indexOf(123)) < path.length()) {
            return this.path.subSequence(0, paramStart).equals(path.subSequence(0, paramStart));
        }
        return this.path.equals(path);
    }

    @Override
    public Method getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public boolean isParameterized() {
        return this.path.contains("{");
    }

    @Override
    public boolean isSecured() {
        return !this.roles.isEmpty();
    }

    @Override
    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public boolean hasExceptionsRoutes() {
        return !this.throwables.isEmpty();
    }

    @Override
    public Set<String> produces() {
        return Collections.unmodifiableSet(this.produces);
    }

    @Override
    public boolean canHandle(Throwable throwable) {
        for (Class<? extends Throwable> t : this.throwables) {
            if (!t.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "DefaultRoute[" + "path=" + this.path + ", targetClass=" + this.targetClass + ", targetMethod=" + this.targetMethod + ", roles=" + this.roles + ", throwables=" + this.throwables + "]";
    }

    private Set<RequestMethod> asSet(RequestMethod[] methods) {
        return methods == null ? Collections.emptySet() : new HashSet<RequestMethod>(Arrays.asList(methods));
    }

    private Set<String> asSet(String[] strings) {
        return new HashSet<String>(Arrays.asList(strings));
    }

    private static Set<Class<? extends Throwable>> emptyThrowableSet() {
        return Collections.emptySet();
    }

    private static String[] defaultMediaType() {
        return new String[]{MediaType.HTML.toString()};
    }
}

