/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import br.com.caelum.iogi.Iogi;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.DependencyProvider;
import br.com.caelum.iogi.spi.LocaleProvider;
import br.com.caelum.iogi.util.DefaultLocaleProvider;
import br.com.caelum.iogi.util.NullDependencyProvider;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.Responder;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.util.RequestUtils;
import org.jboss.aerogear.controller.util.StringUtils;

public class DefaultRouteProcessor
implements RouteProcessor {
    private BeanManager beanManager;
    private final Iogi iogi = new Iogi((DependencyProvider)new NullDependencyProvider(), (LocaleProvider)new DefaultLocaleProvider());
    private ControllerFactory controllerFactory;
    private Set<Responder> responders = new LinkedHashSet<Responder>();

    public DefaultRouteProcessor() {
    }

    @Inject
    public DefaultRouteProcessor(BeanManager beanManager, Instance<Responder> responders, ControllerFactory controllerFactory) {
        this.beanManager = beanManager;
        this.controllerFactory = controllerFactory;
        for (Responder responder : responders) {
            this.responders.add(responder);
        }
    }

    @Override
    public void process(RouteContext routeContext) throws Exception {
        HttpServletRequest request = routeContext.getRequest();
        String requestPath = routeContext.getRequestPath();
        Route route = routeContext.getRoute();
        Object[] params = route.isParameterized() ? this.extractPathParameters(requestPath, route) : this.extractParameters(request, route);
        Object result = route.getTargetMethod().invoke(this.getController(route), params);
        Set<String> acceptHeaders = RequestUtils.extractAcceptHeader(request);
        for (String mediaType : Sets.intersection(route.produces(), acceptHeaders)) {
            if (!this.respond(mediaType, result, routeContext)) continue;
            return;
        }
        if (acceptHeaders.contains(MediaType.ANY.toString())) {
            this.respond(MediaType.ANY.toString(), result, routeContext);
        }
    }

    private boolean respond(String mediaType, Object result, RouteContext routeContext) throws Exception {
        for (Responder responder : this.responders) {
            if (!responder.accepts(mediaType)) continue;
            responder.respond(result, routeContext);
            return true;
        }
        return false;
    }

    private Object[] extractPathParameters(String requestPath, Route route) {
        int paramOffset = route.getPath().indexOf(123);
        CharSequence param = requestPath.subSequence(paramOffset, requestPath.length());
        return new Object[]{((Object)param).toString()};
    }

    private Object[] extractParameters(HttpServletRequest request, Route route) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value.length == 1) {
                parameters.add(new Parameter((String)entry.getKey(), value[0]));
                continue;
            }
            AeroGearLogger.LOGGER.multivaluedParamsUnsupported();
        }
        Class<?>[] parameterTypes = route.getTargetMethod().getParameterTypes();
        if (parameterTypes.length == 1) {
            Class<?> parameterType = parameterTypes[0];
            Target target = Target.create(parameterType, (String)StringUtils.downCaseFirst(parameterType.getSimpleName()));
            Object instantiate = this.iogi.instantiate(target, parameters.toArray(new Parameter[parameters.size()]));
            return new Object[]{instantiate};
        }
        return new Object[0];
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

