/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.controller.router.DefaultRoute;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteBuilder;
import org.jboss.aerogear.controller.router.RouteDescriptor;

public class RouteBuilderImpl
implements RouteBuilder {
    private final RouteDescriptor routeDescriptor = new RouteDescriptor();

    @Override
    public RouteBuilder.OnMethods from(String path) {
        this.routeDescriptor.setPath(path);
        return this.routeDescriptor;
    }

    @Override
    public Route build() {
        return new DefaultRoute(this.routeDescriptor);
    }

    public String toString() {
        return "RouteBuilderImpl{routeDescriptor=" + this.routeDescriptor + '}';
    }

    @Override
    public RouteBuilder.TargetEndpoint on(Class<? extends Throwable> exception, Class<?> ... exceptions) {
        Set<Class<? extends Throwable>> set = this.exceptions(exceptions);
        set.add(exception);
        this.routeDescriptor.setThrowables(set);
        return this.routeDescriptor;
    }

    private Set<Class<? extends Throwable>> exceptions(Class<?> ... exceptions) {
        List<Class<?>> list = Arrays.asList(exceptions);
        HashSet set = new HashSet();
        for (Class<?> e : list) {
            if (!Throwable.class.isAssignableFrom(e)) {
                throw new IllegalArgumentException("Class '" + e.getName() + "' must be a subclass of Throwable");
            }
            set.add(e);
        }
        return new HashSet<Class<? extends Throwable>>(set);
    }
}

