/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators.cors;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.router.decorators.cors.CorsConfiguration;

public class Cors {
    private final HttpServletRequest request;
    private final CorsConfiguration corsConfig;

    public Cors(CorsConfiguration corsConfig, HttpServletRequest request) {
        this.request = request;
        this.corsConfig = corsConfig;
    }

    public boolean isCorsRequest() {
        return this.hasOriginHeader();
    }

    public boolean canHandleRequest() {
        return this.isCorsSupportEnabled() && this.isCorsRequest();
    }

    public boolean isCorsSupportEnabled() {
        return this.corsConfig.isCorsSupportEnabled();
    }

    public boolean hasOriginHeader() {
        return this.hasHeader(RequestHeader.ORIGIN.toString());
    }

    public boolean isOptionsMethod() {
        return this.request.getMethod().equals(RequestHeader.OPTIONS.toString());
    }

    public boolean isPreflightRequest() {
        return this.hasOriginHeader() && this.isOptionsMethod() && this.hasHeader(RequestHeader.METHOD.toString());
    }

    public boolean isRequestMethodValid(Set<String> validMethods) {
        String method = this.request.getHeader(RequestHeader.METHOD.toString());
        return validMethods.contains(method);
    }

    public boolean isRequestMethodValid() {
        return this.isRequestMethodValid(this.corsConfig.getValidRequestMethods());
    }

    public boolean hasRequestHeaders() {
        return this.hasHeader(RequestHeader.HEADERS.toString());
    }

    public String getRequestHeaders() {
        return this.request.getHeader(RequestHeader.HEADERS.toString());
    }

    public String getRequestMethod() {
        return this.request.getHeader(RequestHeader.METHOD.toString());
    }

    public Set<String> getAllowedRequestMethods() {
        return this.corsConfig.getValidRequestMethods();
    }

    public Set<String> getAllowedRequestHeaders() {
        return this.corsConfig.getValidRequestHeaders();
    }

    public Cors setEchoOrigin(HttpServletResponse response) {
        return this.setOrigin(response, this.request.getHeader(RequestHeader.ORIGIN.headerName));
    }

    public Cors setOrigin(HttpServletResponse response) {
        if (this.corsConfig.anyOrigin()) {
            this.setAnyOrigin(response);
        } else {
            this.setEchoOrigin(response);
        }
        return this;
    }

    public Cors setOrigin(HttpServletResponse response, String origin) {
        if (this.hasOriginHeader()) {
            response.setHeader(ResponseHeader.ALLOW_ORIGIN.toString(), origin);
        }
        return this;
    }

    public Cors setAnyOrigin(HttpServletResponse response) {
        return this.setOrigin(response, "*");
    }

    public Cors setAllowCredentials(HttpServletResponse response) {
        if (this.corsConfig.allowCookies()) {
            response.setHeader(ResponseHeader.ALLOW_CREDENTIALS.toString(), Boolean.TRUE.toString());
        }
        return this;
    }

    public Cors setExposeHeaders(HttpServletResponse response) {
        String headers;
        if (this.corsConfig.exposeHeaders() && (headers = this.corsConfig.getExposeHeaders()) != null) {
            response.setHeader(ResponseHeader.EXPOSE_HEADERS.toString(), headers);
        }
        return this;
    }

    public Cors setAllowMethods(HttpServletResponse response) {
        Set<String> httpMethods = this.corsConfig.getValidRequestMethods();
        if (httpMethods != null) {
            response.setHeader(ResponseHeader.ALLOW_METHODS.toString(), Joiner.on((String)",").join(httpMethods));
        }
        return this;
    }

    public Cors setMaxAge(HttpServletResponse response) {
        if (this.corsConfig.hasMaxAge()) {
            response.setHeader(ResponseHeader.MAX_AGE.toString(), Long.toString(this.corsConfig.getMaxAge()));
        }
        return this;
    }

    public boolean areRequestHeadersValid(final Set<String> validHeaders) {
        String requestHeaders = this.request.getHeader(RequestHeader.HEADERS.headerName);
        if (requestHeaders == null) {
            return true;
        }
        Iterable headers = Splitter.on((char)',').trimResults().split((CharSequence)requestHeaders);
        boolean valid = Iterables.all((Iterable)headers, (Predicate)new Predicate<String>(){

            public boolean apply(String header) {
                return validHeaders.contains(header.toLowerCase());
            }
        });
        return valid;
    }

    public boolean areRequestHeadersValid() {
        return this.areRequestHeadersValid(this.corsConfig.getValidRequestHeaders());
    }

    public Cors setAllowHeaders(HttpServletResponse response) {
        response.setHeader(ResponseHeader.ALLOW_HEADERS.toString(), Joiner.on((char)',').join(this.corsConfig.getValidRequestHeaders().toArray()));
        return this;
    }

    private boolean hasHeader(String name) {
        return this.request.getHeader(name) != null;
    }

    public static enum ResponseHeader {
        ALLOW_ORIGIN("Access-Control-Allow-Origin"),
        ALLOW_CREDENTIALS("Access-Control-Allow-Credentials"),
        EXPOSE_HEADERS("Access-Control-Expose-Headers"),
        ALLOW_METHODS("Access-Control-Allow-Methods"),
        MAX_AGE("Access-Control-Max-Age"),
        ALLOW_HEADERS("Access-Control-Allow-Headers");

        private final String headerName;

        private ResponseHeader(String headerName) {
            this.headerName = headerName;
        }

        public String toString() {
            return this.headerName;
        }
    }

    public static enum RequestHeader {
        ORIGIN("Origin"),
        OPTIONS("OPTIONS"),
        METHOD("Access-Control-Request-Method"),
        HEADERS("Access-Control-Request-Headers");

        private final String headerName;

        private RequestHeader(String headerName) {
            this.headerName = headerName;
        }

        public String toString() {
            return this.headerName;
        }
    }
}

