/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.router.rest.pagination.PagingMetadata;
import org.jboss.aerogear.controller.router.rest.pagination.PagingProperties;
import org.jboss.aerogear.controller.router.rest.pagination.PagingStrategy;
import org.jboss.aerogear.controller.router.rest.pagination.RequestPathParser;

public class OffsetPagingStrategy
implements PagingStrategy {
    public static final String DEFAULT_OFFSET_PARAM_NAME = "offset";
    public static final String DEFAULT_LIMIT_PARAM_NAME = "limit";
    private final PaginationInfo pagingInfo;
    private final Optional<String> headerPrefix;

    public OffsetPagingStrategy(PaginationInfo paginationInfo) {
        this(paginationInfo, (Optional<String>)Optional.absent());
    }

    public OffsetPagingStrategy(PaginationInfo paginationInfo, String headerPrefix) {
        this(paginationInfo, (Optional<String>)Optional.fromNullable((Object)headerPrefix));
    }

    private OffsetPagingStrategy(PaginationInfo paginationInfo, Optional<String> headerPrefix) {
        this.pagingInfo = paginationInfo;
        this.headerPrefix = headerPrefix;
    }

    @Override
    public Object process(Object result, RouteContext routeContext) {
        if (!(result instanceof Collection)) {
            return result;
        }
        Collection results = (Collection)result;
        Map<String, String> headers = this.createMetadata(routeContext).getHeaders(results.size());
        HttpServletResponse response = routeContext.getResponse();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        return results;
    }

    private PagingMetadata createMetadata(RouteContext routeContext) {
        RequestPathParser requestPathParser = new RequestPathParser(this.pagingInfo, this.getResourcePath(routeContext));
        PagingProperties pagingProperties = new PagingProperties(this.pagingInfo.getOffset(), this.pagingInfo.getLimit());
        if (this.headerPrefix.isPresent()) {
            return new PagingMetadata(pagingProperties, requestPathParser, (String)this.headerPrefix.get());
        }
        return new PagingMetadata(pagingProperties, requestPathParser);
    }

    private String getResourcePath(RouteContext routeContext) {
        HttpServletRequest request = routeContext.getRequest();
        String resourcePath = request.getRequestURL().toString() + "?" + routeContext.getRequest().getQueryString();
        if (resourcePath.startsWith("/")) {
            return resourcePath.substring(1);
        }
        return resourcePath;
    }

    @Override
    public PaginationInfo getPaginationInfo() {
        return this.pagingInfo;
    }
}

