/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.rest.pagination;

import org.jboss.aerogear.controller.router.rest.pagination.OffsetPagingStrategy;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;

public final class Pagination {
    private Pagination() {
    }

    public static OffsetStrategyBuilder offsetValue(String value) {
        return Pagination.offset("offset", value);
    }

    public static OffsetStrategyBuilder offset(String offsetParamName, String value) {
        return new OffsetStrategyBuilderImpl().offsetParam(offsetParamName, value);
    }

    public static class OffsetStrategyBuilderImpl
    implements OffsetStrategyBuilder {
        private String offsetParamName = "offset";
        private String limitParamName = "limit";
        private String headerPrefix;
        private String offsetParamValue;
        private String limitParamValue;
        private boolean webLinking;

        @Override
        public OffsetStrategyBuilder offsetParam(String paramName, String value) {
            this.offsetParamName = paramName;
            this.offsetParamValue = value;
            return this;
        }

        @Override
        public OffsetStrategyBuilder limitParam(String paramName, String value) {
            this.limitParamName = paramName;
            this.limitParamValue = value;
            return this;
        }

        @Override
        public OffsetStrategyBuilder customHeadersPrefix(String prefix) {
            this.headerPrefix = prefix;
            return this;
        }

        @Override
        public OffsetStrategyBuilder customHeaders() {
            this.headerPrefix = "AG-";
            return this;
        }

        @Override
        public OffsetPagingStrategy build() {
            PaginationInfo info = new PaginationInfo(this.offsetParamName, this.offsetParamValue, this.limitParamName, this.limitParamValue);
            return this.webLinking ? new OffsetPagingStrategy(info) : new OffsetPagingStrategy(info, this.headerPrefix);
        }

        @Override
        public OffsetStrategyBuilder limitValue(String value) {
            this.limitParamValue = value;
            return this;
        }

        @Override
        public OffsetStrategyBuilder webLinking(boolean enabled) {
            this.webLinking = enabled;
            return this;
        }
    }

    public static interface OffsetStrategyBuilder {
        public OffsetStrategyBuilder offsetParam(String var1, String var2);

        public OffsetStrategyBuilder limitParam(String var1, String var2);

        public OffsetStrategyBuilder limitValue(String var1);

        public OffsetStrategyBuilder customHeaders();

        public OffsetStrategyBuilder customHeadersPrefix(String var1);

        public OffsetStrategyBuilder webLinking(boolean var1);

        public OffsetPagingStrategy build();
    }
}

