/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.HeartbeatFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

abstract class AbstractTimersSessionState
implements SessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTimersSessionState.class);
    private final ConcurrentMap<String, SockJsSession> sessions;
    private ScheduledFuture<?> heartbeatFuture;
    private ScheduledFuture<?> sessionTimer;

    protected AbstractTimersSessionState(ConcurrentMap<String, SockJsSession> sessions) {
        ArgumentUtil.checkNotNull(sessions, "sessions");
        this.sessions = sessions;
    }

    @Override
    public void onConnect(SockJsSession session, ChannelHandlerContext ctx) {
        this.startSessionTimer(ctx, session);
        this.startHeartbeatTimer(ctx, session);
    }

    private void startSessionTimer(ChannelHandlerContext ctx, final SockJsSession session) {
        if (this.sessionTimer == null) {
            this.sessionTimer = ctx.executor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (AbstractTimersSessionState.this.isInUse(session)) {
                        return;
                    }
                    if (session.timestamp() + session.config().sessionTimeout() < now) {
                        SockJsSession removed = (SockJsSession)AbstractTimersSessionState.this.sessions.remove(session.sessionId());
                        session.connectionContext().close();
                        AbstractTimersSessionState.this.sessionTimer.cancel(true);
                        AbstractTimersSessionState.this.heartbeatFuture.cancel(true);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Removed {} from map[{}]", (Object)removed.sessionId(), (Object)AbstractTimersSessionState.this.sessions.size());
                        }
                    }
                }
            }, session.config().sessionTimeout(), session.config().sessionTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void startHeartbeatTimer(final ChannelHandlerContext ctx, final SockJsSession session) {
        this.heartbeatFuture = ctx.executor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sending heartbeat for {}", (Object)session);
                    }
                    ctx.channel().writeAndFlush((Object)new HeartbeatFrame());
                }
            }
        }, session.config().heartbeatInterval(), session.config().heartbeatInterval(), TimeUnit.MILLISECONDS);
    }
}

