/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.AbstractTimersSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;

class PollingSessionState
extends AbstractTimersSessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PollingSessionState.class);
    private final ConcurrentMap<String, SockJsSession> sessions;

    PollingSessionState(ConcurrentMap<String, SockJsSession> sessions) {
        super(sessions);
        this.sessions = sessions;
    }

    @Override
    public void onOpen(SockJsSession session, ChannelHandlerContext ctx) {
        this.flushMessages(ctx, session);
    }

    @Override
    public ChannelHandlerContext getSendingContext(SockJsSession session) {
        ChannelHandlerContext openContext = session.openContext();
        return openContext == null ? session.connectionContext() : openContext;
    }

    private void flushMessages(ChannelHandlerContext ctx, final SockJsSession session) {
        final String[] allMessages = session.getAllMessages();
        if (allMessages.length == 0) {
            return;
        }
        MessageFrame messageFrame = new MessageFrame(allMessages);
        ChannelFuture channelFuture = ctx.channel().writeAndFlush((Object)messageFrame);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    session.addMessages(allMessages);
                }
            }
        });
        channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    public boolean isInUse(SockJsSession session) {
        return session.connectionContext().channel().isActive() || session.inuse();
    }

    @Override
    public void onSockJSServerInitiatedClose(SockJsSession session) {
        ChannelHandlerContext context = session.connectionContext();
        if (context != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Will close session connectionContext {}", (Object)session.connectionContext());
            }
            context.close();
        }
        this.sessions.remove(session.sessionId());
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
    }
}

