/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

class SendingSessionState
implements SessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SendingSessionState.class);
    private final ConcurrentMap<String, SockJsSession> sessions;

    SendingSessionState(ConcurrentMap<String, SockJsSession> sessions) {
        ArgumentUtil.checkNotNull(sessions, "sessions");
        this.sessions = sessions;
    }

    @Override
    public void onConnect(SockJsSession session, ChannelHandlerContext ctx) {
    }

    @Override
    public void onOpen(SockJsSession session, ChannelHandlerContext ctx) {
    }

    @Override
    public ChannelHandlerContext getSendingContext(SockJsSession session) {
        return session.openContext();
    }

    @Override
    public void onSockJSServerInitiatedClose(SockJsSession session) {
        if (logger.isDebugEnabled()) {
            logger.debug("Will close session connectionContext {}", (Object)session.connectionContext());
        }
        session.connectionContext().close();
        this.sessions.remove(session.sessionId());
    }

    @Override
    public boolean isInUse(SockJsSession session) {
        return false;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
    }
}

