/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.AbstractTimersSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;

class StreamingSessionState
extends AbstractTimersSessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StreamingSessionState.class);

    StreamingSessionState(ConcurrentMap<String, SockJsSession> sessions) {
        super(sessions);
    }

    @Override
    public void onOpen(SockJsSession session, ChannelHandlerContext ctx) {
        StreamingSessionState.flushMessages(ctx, session);
    }

    @Override
    public ChannelHandlerContext getSendingContext(SockJsSession session) {
        return session.connectionContext();
    }

    private static void flushMessages(ChannelHandlerContext ignored, final SockJsSession session) {
        Channel channel = session.connectionContext().channel();
        if (channel.isActive() && channel.isRegistered()) {
            final String[] allMessages = session.getAllMessages();
            if (allMessages.length == 0) {
                return;
            }
            MessageFrame messageFrame = new MessageFrame(allMessages);
            logger.debug("flushing [{}]", (Object)messageFrame);
            channel.writeAndFlush((Object)messageFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        session.addMessages(allMessages);
                    }
                }
            });
        }
    }

    @Override
    public void onSockJSServerInitiatedClose(SockJsSession session) {
        ChannelHandlerContext context = session.connectionContext();
        if (context != null) {
            logger.debug("Will close session connectionContext " + session.connectionContext());
            context.close();
        }
    }

    @Override
    public boolean isInUse(SockJsSession session) {
        return session.connectionContext().channel().isActive();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
    }
}

