/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.HeartbeatFrame;

class WebSocketSessionState
implements SessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketSessionState.class);
    private ScheduledFuture<?> heartbeatFuture;

    WebSocketSessionState() {
    }

    @Override
    public void onConnect(SockJsSession session, ChannelHandlerContext ctx) {
        this.startHeartbeatTimer(ctx, session);
    }

    private void startHeartbeatTimer(final ChannelHandlerContext ctx, final SockJsSession session) {
        long interval = session.config().webSocketHeartbeatInterval();
        if (interval > 0L) {
            if (logger.isDebugEnabled()) {
                logger.info("Starting heartbeat with interval {}", (Object)interval);
            }
            this.heartbeatFuture = ctx.executor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sending heartbeat for {}", (Object)session);
                        }
                        ctx.channel().writeAndFlush((Object)new HeartbeatFrame());
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onOpen(SockJsSession session, ChannelHandlerContext ctx) {
    }

    @Override
    public ChannelHandlerContext getSendingContext(SockJsSession session) {
        return session.connectionContext();
    }

    @Override
    public boolean isInUse(SockJsSession session) {
        return session.connectionContext().channel().isActive();
    }

    @Override
    public void onSockJSServerInitiatedClose(SockJsSession session) {
        this.shutdownHearbeat();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
        this.shutdownHearbeat();
    }

    private void shutdownHearbeat() {
        if (this.heartbeatFuture != null) {
            logger.debug("Stopping heartbeat job");
            this.heartbeatFuture.cancel(true);
        }
    }
}

