/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class EventSourceTransport
extends ChannelHandlerAdapter {
    public static final String CONTENT_TYPE_EVENT_STREAM = "text/event-stream; charset=UTF-8";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EventSourceTransport.class);
    private static final ByteBuf FRAME_START = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"data: ", (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf CRLF = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{13, 10}));
    private static final ByteBuf FRAME_END = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{13, 10, 13, 10}));
    private final SockJsConfig config;
    private final HttpRequest request;
    private final AtomicBoolean headerSent = new AtomicBoolean(false);
    private final AtomicInteger bytesSent = new AtomicInteger(0);

    public EventSourceTransport(SockJsConfig config, HttpRequest request) {
        this.config = config;
        this.request = request;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            Frame frame = (Frame)msg;
            if (this.headerSent.compareAndSet(false, true)) {
                ctx.write((Object)this.createResponse(CONTENT_TYPE_EVENT_STREAM), promise);
                ctx.writeAndFlush((Object)new DefaultHttpContent(CRLF.duplicate()));
            }
            ByteBuf data = ctx.alloc().buffer();
            data.writeBytes(FRAME_START.duplicate());
            data.writeBytes(frame.content());
            data.writeBytes(FRAME_END.duplicate());
            int dataSize = data.readableBytes();
            ctx.writeAndFlush((Object)new DefaultHttpContent(data));
            frame.release();
            if (this.maxBytesLimit(dataSize)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("max bytesSize limit reached [{}]", (Object)this.config.maxStreamingBytesSize());
                }
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private boolean maxBytesLimit(int bytesWritten) {
        this.bytesSent.addAndGet(bytesWritten);
        return this.bytesSent.get() >= this.config.maxStreamingBytesSize();
    }

    protected HttpResponse createResponse(String contentType) {
        HttpVersion version = this.request.getProtocolVersion();
        DefaultHttpResponse response = new DefaultHttpResponse(version, HttpResponseStatus.OK);
        if (this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            response.headers().set(HttpHeaders.Names.TRANSFER_ENCODING, (Object)HttpHeaders.Values.CHUNKED);
        }
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)contentType);
        Transports.setDefaultHeaders((HttpResponse)response, this.config);
        return response;
    }
}

