/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Set;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;

public final class Transports {
    public static final String CONTENT_TYPE_PLAIN = "text/plain; charset=UTF-8";
    public static final String CONTENT_TYPE_JAVASCRIPT = "application/javascript; charset=UTF-8";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    public static final String DEFAULT_COOKIE = "JSESSIONID=dummy;path=/";
    public static final String JSESSIONID = "JSESSIONID";
    private static final String NO_CACHE_HEADER = "no-store, no-cache, must-revalidate, max-age=0";
    private static final ByteBuf NL = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"\n", (Charset)CharsetUtil.UTF_8));

    private Transports() {
    }

    public static String encodeSessionIdCookie(HttpRequest request) {
        String cookieHeader = request.headers().get(HttpHeaders.Names.COOKIE);
        if (cookieHeader != null) {
            Set cookies = CookieDecoder.decode((String)cookieHeader);
            for (Cookie c : cookies) {
                if (!c.getName().equals(JSESSIONID)) continue;
                c.setPath("/");
                return ServerCookieEncoder.encode((Cookie)c);
            }
        }
        return DEFAULT_COOKIE;
    }

    public static void writeContent(FullHttpResponse response, String content, String contentType) {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8);
        response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)buf.readableBytes());
        response.content().writeBytes(buf);
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)contentType);
        buf.release();
    }

    public static void setDefaultHeaders(HttpResponse response, SockJsConfig config) {
        if (config.areCookiesNeeded()) {
            response.headers().set(HttpHeaders.Names.SET_COOKIE, (Object)DEFAULT_COOKIE);
        }
        Transports.setNoCacheHeaders(response);
        Transports.setCORSHeaders(response);
    }

    public static void setDefaultHeaders(FullHttpResponse response, SockJsConfig config, HttpRequest request) {
        if (config.areCookiesNeeded()) {
            response.headers().set(HttpHeaders.Names.SET_COOKIE, (Object)Transports.encodeSessionIdCookie(request));
        }
        Transports.setNoCacheHeaders((HttpResponse)response);
        Transports.setCORSHeaders((HttpResponse)response);
    }

    public static void setSessionIdCookie(FullHttpResponse response, SockJsConfig config, HttpRequest request) {
        if (config.areCookiesNeeded()) {
            response.headers().set(HttpHeaders.Names.SET_COOKIE, (Object)Transports.encodeSessionIdCookie(request));
        }
    }

    public static void setNoCacheHeaders(HttpResponse response) {
        response.headers().set(HttpHeaders.Names.CACHE_CONTROL, (Object)NO_CACHE_HEADER);
    }

    public static void setCORSHeaders(HttpResponse response) {
        response.headers().set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        response.headers().set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
    }

    public static ByteBuf wrapWithLN(ByteBuf buf) {
        return Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{buf, NL.duplicate()});
    }

    public static String escapeCharacters(char[] value) {
        StringBuilder buffer = new StringBuilder();
        for (char ch : value) {
            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\ud800' && ch <= '\udfff' || ch >= '\u200c' && ch <= '\u200f' || ch >= '\u2028' && ch <= '\u202f' || ch >= '\u2060' && ch <= '\u206f' || ch >= '\ufff0' && ch <= '\uffff') {
                String ss = Integer.toHexString(ch);
                buffer.append('\\').append('u');
                for (int k = 0; k < 4 - ss.length(); ++k) {
                    buffer.append('0');
                }
                buffer.append(ss.toLowerCase());
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static ByteBuf escapeJson(ByteBuf input, ByteBuf buffer) {
        int count = input.readableBytes();
        block10: for (int i = 0; i < count; ++i) {
            byte ch = input.getByte(i);
            switch (ch) {
                case 34: {
                    buffer.writeByte(92).writeByte(34);
                    continue block10;
                }
                case 47: {
                    buffer.writeByte(92).writeByte(47);
                    continue block10;
                }
                case 92: {
                    buffer.writeByte(92).writeByte(92);
                    continue block10;
                }
                case 8: {
                    buffer.writeByte(92).writeByte(98);
                    continue block10;
                }
                case 12: {
                    buffer.writeByte(92).writeByte(102);
                    continue block10;
                }
                case 10: {
                    buffer.writeByte(92).writeByte(110);
                    continue block10;
                }
                case 13: {
                    buffer.writeByte(92).writeByte(114);
                    continue block10;
                }
                case 9: {
                    buffer.writeByte(92).writeByte(116);
                    continue block10;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 55296 && ch <= 57343 || ch >= 8204 && ch <= 8207 || ch >= 8232 && ch <= 8239 || ch >= 8288 && ch <= 8303 || ch >= 65520 && ch <= 65535) {
                        String ss = Integer.toHexString(ch);
                        buffer.writeByte(92).writeByte(117);
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            buffer.writeByte(48);
                        }
                        buffer.writeBytes(ss.toLowerCase().getBytes());
                        continue block10;
                    }
                    buffer.writeByte((int)ch);
                }
            }
        }
        return buffer;
    }

    public static FullHttpResponse methodNotAllowedResponse(HttpVersion version) {
        FullHttpResponse response = Transports.responseWithoutContent(version, HttpResponseStatus.METHOD_NOT_ALLOWED);
        response.headers().add(HttpHeaders.Names.ALLOW, (Object)HttpMethod.GET);
        return response;
    }

    public static FullHttpResponse badRequestResponse(HttpVersion version, String content) {
        return Transports.responseWithContent(version, HttpResponseStatus.BAD_REQUEST, CONTENT_TYPE_PLAIN, content);
    }

    public static FullHttpResponse internalServerErrorResponse(HttpVersion version, String content) {
        return Transports.responseWithContent(version, HttpResponseStatus.INTERNAL_SERVER_ERROR, CONTENT_TYPE_PLAIN, content);
    }

    public static void respond(ChannelHandlerContext ctx, HttpVersion version, HttpResponseStatus status, String contentType, String content, ChannelPromise promise) {
        FullHttpResponse response = Transports.responseWithContent(version, status, contentType, content);
        Transports.writeResponse(ctx, (HttpResponse)response);
    }

    public static void respond(ChannelHandlerContext ctx, HttpVersion version, HttpResponseStatus status, String contentType, String content) {
        FullHttpResponse response = Transports.responseWithContent(version, status, contentType, content);
        Transports.writeResponse(ctx, (HttpResponse)response);
    }

    public static FullHttpResponse responseWithoutContent(HttpVersion version, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(version, status);
        response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)0);
        return response;
    }

    public static FullHttpResponse responseWithContent(HttpVersion version, HttpResponseStatus status, String contentType, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(version, status);
        Transports.writeContent((FullHttpResponse)response, content, contentType);
        return response;
    }

    public static void writeResponse(ChannelHandlerContext ctx, HttpResponse response) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            ctx.writeAndFlush((Object)response);
        }
    }

    public static void writeResponse(ChannelHandlerContext ctx, ChannelPromise promise, HttpResponse response) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            ctx.writeAndFlush((Object)response, promise);
        }
    }

    public static enum Type {
        WEBSOCKET,
        XHR,
        XHR_SEND,
        XHR_STREAMING,
        JSONP,
        JSONP_SEND,
        EVENTSOURCE,
        HTMLFILE;


        public String path() {
            return '/' + this.name().toLowerCase();
        }
    }
}

