/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import com.fasterxml.jackson.core.JsonParseException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsInboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsOutboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.WebSocketHAProxyHandshaker;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.WebSocketHAProxyTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.WebSocketSendHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.JsonUtil;

public class WebSocketTransport
extends SimpleChannelInboundHandler<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketTransport.class);
    private static final AttributeKey<HttpRequest> REQUEST_KEY = AttributeKey.valueOf((String)"request.key");
    private final SockJsConfig config;
    private WebSocketServerHandshaker handshaker;

    public WebSocketTransport(SockJsConfig config) {
        this.config = config;
    }

    protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private static boolean checkRequestHeaders(ChannelHandlerContext ctx, HttpRequest req) {
        if (req.getMethod() != HttpMethod.GET) {
            logger.debug("Request was not of type GET, was {}", (Object)req.getMethod());
            ctx.writeAndFlush((Object)Transports.methodNotAllowedResponse(req.getProtocolVersion())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        String upgradeHeader = req.headers().get(HttpHeaders.Names.UPGRADE);
        if (upgradeHeader == null || !"websocket".equals(upgradeHeader.toLowerCase())) {
            logger.debug("Upgrade header was not 'websocket' was: {}", (Object)upgradeHeader);
            ctx.writeAndFlush((Object)Transports.badRequestResponse(req.getProtocolVersion(), "Can \"Upgrade\" only to \"WebSocket\".")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        String connectHeader = req.headers().get(HttpHeaders.Names.CONNECTION);
        if (connectHeader != null && "keep-alive, upgrade".equals(connectHeader.toLowerCase())) {
            logger.debug("Connection header was not 'keep-alive, upgrade' was: {}", (Object)connectHeader);
            req.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.UPGRADE);
            connectHeader = HttpHeaders.Values.UPGRADE.toString();
        }
        if (connectHeader == null || !"upgrade".equals(connectHeader.toLowerCase())) {
            logger.debug("Connection header was not 'upgrade' was: {}", (Object)connectHeader);
            ctx.writeAndFlush((Object)Transports.badRequestResponse(req.getProtocolVersion(), "\"Connection\" must be \"Upgrade\".")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        return true;
    }

    private void handleHttpRequest(final ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!WebSocketTransport.checkRequestHeaders(ctx, (HttpRequest)req)) {
            return;
        }
        ctx.attr(REQUEST_KEY).set((Object)req);
        if (WebSocketHAProxyHandshaker.isHAProxyReqeust(req)) {
            String wsUrl = WebSocketTransport.getWebSocketLocation(this.config.isTls(), req);
            final WebSocketHAProxyHandshaker haHandshaker = new WebSocketHAProxyHandshaker(wsUrl, null, 65365);
            ChannelFuture handshakeFuture = haHandshaker.handshake(ctx.channel(), req);
            handshakeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ChannelPipeline pipeline = future.channel().pipeline();
                        pipeline.remove(SockJsHandler.class);
                        pipeline.remove(CorsInboundHandler.class);
                        pipeline.remove(CorsOutboundHandler.class);
                        pipeline.replace(WebSocketTransport.class, "websocket-ha-proxy", (ChannelHandler)new WebSocketHAProxyTransport(haHandshaker));
                        pipeline.addLast(new ChannelHandler[]{new WebSocketSendHandler()});
                    }
                }
            });
            return;
        }
        String wsUrl = WebSocketTransport.getWebSocketLocation(this.config.isTls(), req, Transports.Type.WEBSOCKET.path());
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, null, false);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)ctx.channel());
        } else {
            ChannelFuture handshakeFuture = this.handshaker.handshake(ctx.channel(), req);
            handshakeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ctx.pipeline().remove(SockJsHandler.class);
                        ctx.pipeline().remove(CorsInboundHandler.class);
                        ctx.pipeline().remove(CorsOutboundHandler.class);
                        ctx.pipeline().addLast(new ChannelHandler[]{new WebSocketSendHandler()});
                    } else {
                        logger.error("Handshake error", future.cause());
                    }
                }
            });
            ctx.fireChannelRead((Object)req);
        }
    }

    private static String getWebSocketLocation(boolean tls, FullHttpRequest req) {
        String protocol = tls ? "wss://" : "ws://";
        return protocol + req.headers().get(HttpHeaders.Names.HOST) + req.getUri();
    }

    private static String getWebSocketLocation(boolean tls, FullHttpRequest req, String path) {
        String protocol = tls ? "wss://" : "ws://";
        return protocol + req.headers().get(HttpHeaders.Names.HOST) + path;
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame wsFrame) throws Exception {
        String[] messages;
        if (wsFrame instanceof CloseWebSocketFrame) {
            wsFrame.retain();
            logger.debug("CloseWebSocketFrame received");
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)wsFrame);
            ctx.fireUserEventTriggered((Object)SessionHandler.Events.CLOSE_SESSION);
            return;
        }
        if (wsFrame instanceof PingWebSocketFrame) {
            logger.debug("PingWebSocketFrame received");
            wsFrame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(wsFrame.content()));
            return;
        }
        if (!(wsFrame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", wsFrame.getClass().getName()));
        }
        for (String message : messages = JsonUtil.decode((TextWebSocketFrame)wsFrame)) {
            ctx.fireChannelRead((Object)message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof JsonParseException) {
            logger.trace("Failed to part JSON", cause);
            ctx.close();
        } else if (cause instanceof WebSocketHandshakeException) {
            HttpRequest request = (HttpRequest)ctx.attr(REQUEST_KEY).get();
            logger.error("Failed with ws handshake for request: " + request, cause);
            ctx.writeAndFlush((Object)Transports.internalServerErrorResponse(request.getProtocolVersion(), cause.getMessage())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

