/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsMetadata;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class CorsInboundHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    static final AttributeKey<CorsMetadata> CORS = AttributeKey.valueOf((String)"cors.metadata");

    public void messageReceived(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        CorsMetadata metadata = CorsInboundHandler.extractCorsMetadata(request);
        if (CorsInboundHandler.isPreflightRequest(request)) {
            CorsInboundHandler.handlePreflight(ctx, metadata, request);
        } else {
            ctx.channel().attr(CORS).set((Object)metadata);
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)request));
        }
    }

    private static void handlePreflight(ChannelHandlerContext ctx, CorsMetadata md, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.NO_CONTENT);
        HttpHeaders headers = response.headers();
        headers.set(HttpHeaders.Names.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        headers.set(HttpHeaders.Names.CACHE_CONTROL, (Object)"max-age=31536000, public");
        headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)md.origin());
        headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        headers.set(HttpHeaders.Names.ACCESS_CONTROL_MAX_AGE, (Object)"31536000");
        if (CorsInboundHandler.isPollingTransport(request.getUri())) {
            headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_METHODS, (Object)"OPTIONS, POST");
        } else {
            headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_METHODS, (Object)"OPTIONS, GET");
        }
        headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Content-Type");
        headers.set(HttpHeaders.Names.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        headers.set(HttpHeaders.Names.EXPIRES, (Object)"dummy");
        headers.set(HttpHeaders.Names.SET_COOKIE, (Object)"JSESSIONID=dummy;path=/");
        ctx.writeAndFlush((Object)response);
    }

    private static boolean isPollingTransport(String uri) {
        return uri.contains(Transports.Type.XHR.path());
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        return request.getMethod().equals((Object)HttpMethod.OPTIONS);
    }

    private static CorsMetadata extractCorsMetadata(HttpRequest request) {
        String origin = request.headers().get(HttpHeaders.Names.ORIGIN);
        String headers = request.headers().get(HttpHeaders.Names.ACCESS_CONTROL_REQUEST_HEADERS);
        return new CorsMetadata(origin, headers);
    }
}

