/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.AbstractTimersSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;

class PollingSessionState
extends AbstractTimersSessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PollingSessionState.class);
    private final ConcurrentMap<String, SockJsSession> sessions;

    PollingSessionState(ConcurrentMap<String, SockJsSession> sessions, SockJsSession session) {
        super(sessions, session);
        this.sessions = sessions;
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        super.onOpen(ctx);
        this.flushMessages(ctx);
    }

    @Override
    public ChannelHandlerContext getSendingContext() {
        ChannelHandlerContext openContext = this.getSockJsSession().openContext();
        return openContext == null ? this.getSockJsSession().connectionContext() : openContext;
    }

    private void flushMessages(ChannelHandlerContext ctx) {
        final List<String> allMessages = this.getSockJsSession().getAllMessages();
        if (allMessages.isEmpty()) {
            return;
        }
        MessageFrame messageFrame = new MessageFrame(allMessages);
        ctx.channel().writeAndFlush((Object)messageFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    SockJsSession sockJsSession = PollingSessionState.this.getSockJsSession();
                    for (String msg : allMessages) {
                        sockJsSession.addMessage(msg);
                    }
                }
            }
        }).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    public boolean isInUse() {
        return this.getSockJsSession().connectionContext().channel().isActive() || this.getSockJsSession().inuse();
    }

    @Override
    public void onSockJSServerInitiatedClose() {
        ChannelHandlerContext context = this.getSockJsSession().connectionContext();
        if (context != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Will close session connectionContext {}", (Object)this.getSockJsSession().connectionContext());
            }
            context.close();
        }
        this.sessions.remove(this.getSockJsSession().sessionId());
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }
}

