/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;

class SendingSessionState
implements SessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SendingSessionState.class);
    private final ConcurrentMap<String, SockJsSession> sessions;
    private final SockJsSession session;

    SendingSessionState(ConcurrentMap<String, SockJsSession> sessions, SockJsSession session) {
        ArgumentUtil.checkNotNull(sessions, "sessions");
        this.sessions = sessions;
        this.session = session;
    }

    @Override
    public SessionState.State getState() {
        return this.session.getState();
    }

    @Override
    public void setState(SessionState.State state) {
        this.session.setState(state);
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx, SockJsSessionContext sockJsSessionContext) {
        this.session.setConnectionContext(ctx);
        this.session.onOpen(sockJsSessionContext);
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        this.session.setInuse(true);
    }

    @Override
    public void onMessage(String message) throws Exception {
        this.session.onMessage(message);
    }

    @Override
    public ChannelHandlerContext getSendingContext() {
        return this.session.openContext();
    }

    @Override
    public void onSockJSServerInitiatedClose() {
        if (logger.isDebugEnabled()) {
            logger.debug("Will close session connectionContext {}", (Object)this.session.connectionContext());
        }
        this.session.connectionContext().close();
        this.sessions.remove(this.session.sessionId());
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public void setInuse() {
    }

    @Override
    public void resetInuse() {
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
        this.session.onClose();
    }

    @Override
    public void storeMessage(String message) {
        this.session.addMessage(message);
    }
}

