/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsService;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;

final class SockJsSession {
    private final String sessionId;
    private final SockJsService service;
    private final AtomicLong timestamp = new AtomicLong();
    private final AtomicBoolean inuse = new AtomicBoolean();
    private final ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue();
    private final AtomicReference<SessionState.State> state = new AtomicReference<SessionState.State>(SessionState.State.CONNECTING);
    private final AtomicReference<ChannelHandlerContext> connectionCtx = new AtomicReference();
    private final AtomicReference<ChannelHandlerContext> openCtx = new AtomicReference();

    SockJsSession(String sessionId, SockJsService service) {
        this.sessionId = sessionId;
        this.service = service;
    }

    public ChannelHandlerContext connectionContext() {
        return this.connectionCtx.get();
    }

    public void setConnectionContext(ChannelHandlerContext ctx) {
        ChannelHandlerContext oldCtx;
        while (!this.connectionCtx.compareAndSet(oldCtx = this.connectionCtx.get(), ctx)) {
        }
    }

    public ChannelHandlerContext openContext() {
        return this.openCtx.get();
    }

    public void setOpenContext(ChannelHandlerContext ctx) {
        ChannelHandlerContext oldCtx;
        while (!this.openCtx.compareAndSet(oldCtx = this.openCtx.get(), ctx)) {
        }
    }

    public void setState(SessionState.State newState) {
        SessionState.State oldState;
        while (!this.state.compareAndSet(oldState = this.state.get(), newState)) {
        }
    }

    public SessionState.State getState() {
        return this.state.get();
    }

    public boolean inuse() {
        return this.inuse.get();
    }

    public void setInuse(boolean use) {
        this.inuse.set(use);
    }

    public SockJsConfig config() {
        return this.service.config();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void onMessage(String message) throws Exception {
        this.service.onMessage(message);
        this.updateTimestamp();
    }

    public void onOpen(SockJsSessionContext session) {
        this.setState(SessionState.State.OPEN);
        this.service.onOpen(session);
        this.updateTimestamp();
    }

    public void onClose() {
        this.setState(SessionState.State.CLOSED);
        this.service.onClose();
    }

    public void addMessage(String message) {
        this.messageQueue.add(message);
        this.updateTimestamp();
    }

    public List<String> getAllMessages() {
        String msg;
        ArrayList<String> all = new ArrayList<String>();
        while ((msg = this.messageQueue.poll()) != null) {
            all.add(msg);
        }
        return all;
    }

    public void addMessages(String[] messages) {
        for (String msg : messages) {
            this.messageQueue.add(msg);
        }
    }

    private void updateTimestamp() {
        this.timestamp.set(System.currentTimeMillis());
    }

    public long timestamp() {
        return this.timestamp.get();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "[sessionId=" + this.sessionId + ", state=" + this.state + ']';
    }
}

