/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.AbstractTimersSessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.MessageFrame;

class StreamingSessionState
extends AbstractTimersSessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StreamingSessionState.class);

    StreamingSessionState(ConcurrentMap<String, SockJsSession> sessions, SockJsSession session) {
        super(sessions, session);
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        super.onOpen(ctx);
        this.flushMessages();
    }

    @Override
    public ChannelHandlerContext getSendingContext() {
        return this.getSockJsSession().connectionContext();
    }

    private void flushMessages() {
        Channel channel = this.getSockJsSession().connectionContext().channel();
        if (channel.isActive() && channel.isRegistered()) {
            final List<String> allMessages = this.getSockJsSession().getAllMessages();
            if (allMessages.isEmpty()) {
                return;
            }
            MessageFrame messageFrame = new MessageFrame(allMessages);
            logger.debug("flushing [{}]", (Object)messageFrame);
            channel.writeAndFlush((Object)messageFrame).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SockJsSession sockJsSession = StreamingSessionState.this.getSockJsSession();
                        for (String msg : allMessages) {
                            sockJsSession.addMessage(msg);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void onSockJSServerInitiatedClose() {
        ChannelHandlerContext context = this.getSockJsSession().connectionContext();
        if (context != null) {
            logger.debug("Will close session connectionContext " + this.getSockJsSession().connectionContext());
            context.close();
        }
    }

    @Override
    public boolean isInUse() {
        return this.getSockJsSession().connectionContext().channel().isActive();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }
}

